/**
* Date:2018年5月29日
* Copyright (c) 2018, jingma All Rights Reserved.
*/

package cn.benma666.iframe;

import cn.benma666.constants.UtilConst;
import cn.benma666.exception.MyException;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.Db;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import org.beetl.sql.core.DSTransactionManager;
import org.beetl.sql.core.SQLManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

/**
 * 基础对象 <br/>
 * 提供日志等常见基础操作，一般都建议基础该类为基础类<br/>
 * date: 2018年5月29日 <br/>
 * @author jingma
 * @version 0.1
 */
public class BasicObject {
    /**
    * 日志
    */
    @JSONField(serialize=false)
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    /**
    * 日志-静态
    */
    protected static Logger slog = LoggerFactory.getLogger(BasicObject.class);
    /**
     * 默认缓存，零碎的都就缓存在这里
     */
    public static final JSONObject defaultCache = CacheFactory.use(UtilConst.DEFAULT);

    //////////////////////接口反馈包装//////////////////////////
    protected static  Result success(String msg){
        return new Result(true,msg);
    }
    protected static  Result success(String msg, Object data){
        return new Result(true,msg,data);
    }
    protected static  Result failed(String msg){
        return new Result(false,msg);
    }
    protected static  Result failed(String msg,Object data){
        return new Result(false,msg,data);
    }

    /**
     * 事务提交
     * @param r 正常结果
     * @return 处理结果
     */
    public static Result swtj(Result r) {
        try {
            if(r.isStatus()){
                //成功提交事务
                DSTransactionManager.commitNesting();
            }else{
                //失败回滚事务
                DSTransactionManager.rollback();
            }
            return r;
        } catch (SQLFeatureNotSupportedException e) {
            //表示该数据库不支持事务
            slog.trace("该数据库不支持事务",e);
            return r;
        } catch (SQLException e) {
            throw new MyException(r.getMsg()+"，事务处理失败"+r,e);
        }
    }

    /**
    * 获取默认数据库操作 <br/>
    * @author jingma
    * @return 默认数据库操作对象
    */
    public Db db(){
        return Db.use();
    }
    /**
    * 获取默认SqlManager <br/>
    * @author jingma
    * @return 默认beetlSql操作对象
    */
    public SQLManager sqlManager(){
        return db().getSqlManager();
    }
    /**
    * 获取指定数据库操作对象 <br/>
    * @author jingma
    * @param name 数据库操作对象名称
    * @return 指定的数据库操作对象
    */
    protected static Db db(String name){
        return Db.use(name);
    }
    /**
    * 获取指定SqlManager <br/>
    * @author jingma
    * @param name SqlManager名称
    * @return 指定SqlManager
    */
    protected static SQLManager sqlManager(String name){
        return db(name).getSqlManager();
    }

    /**
     * @param val 值
     * @param def 默认值
     * @param <T> 类型泛型
     * @return value不为空则返回value，否则返回def
     */
    public static <T> T valByDef(T val, T def){
        return StringUtil.valByDef(val,def);
    }
    /**
     * @param obj 对象
     * @return true：对象为空或空字符串，false：非空
     */
    public static boolean isBlank(Object obj){
        return StringUtil.isBlank(obj);
    }
    /**
     * 非空验证
     */
    public static <T> T requireNonNull(T obj,String msg){
        return StringUtil.requireNonNull(obj,msg);
    }
}
