/**
* Project Name:myutils
* Date:2018年12月4日
* Copyright (c) 2018, jingma All Rights Reserved.
*/

package cn.benma666.exception;

import cn.benma666.iframe.Result;
import cn.benma666.json.JsonUtil;
import lombok.extern.slf4j.Slf4j;

import java.net.HttpURLConnection;

/**
 * 我自己的异常，项目范围内可用，可控 <br/>
 * date: 2018年12月4日 <br/>
 * @author jingma
 * @version 0.1
 */
@Slf4j
public class MyException extends RuntimeException{

    /**
    *
    */
    private static final long serialVersionUID = 1463806345429361813L;
    /**
     * 异常代码
     */
    private int code = HttpURLConnection.HTTP_BAD_REQUEST;
    /**
    * 数据
    */
    private Object data;
    /**
     * Creates a new instance of ExcelReadException.
     */
    public MyException() {
    }

    /**
    * Creates a new instance of ExcelReadException.
    * @param message 异常消息
    */
    public MyException(String message) {
        this(message,null);
    }
    /**
    * Creates a new instance of ExcelReadException.
    * @param message 异常消息
    * @param cause 原异常
    */
    public MyException(String message, Throwable cause) {
        this(message, cause,null,cause==null?HttpURLConnection.HTTP_BAD_REQUEST
                :HttpURLConnection.HTTP_INTERNAL_ERROR,null);
    }
    /**
     * Creates a new instance of ExcelReadException.
     * @param message 异常消息
     * @param cause 原异常
     * @param nbxx 内部信息
     */
    public MyException(String message, Throwable cause, String nbxx) {
        this(message, cause,null,cause==null?HttpURLConnection.HTTP_BAD_REQUEST
                :HttpURLConnection.HTTP_INTERNAL_ERROR,nbxx);
    }
    /**
    * Creates a new instance of MyException.
    * @param message 异常消息
    * @param data 数据
    */
    public MyException(String message, Object data) {
        this(message,null,data,HttpURLConnection.HTTP_BAD_REQUEST,null);
    }
    /**
     * Creates a new instance of MyException.
     * @param message 异常消息
     * @param code 异常代码
     * @param data 数据
     */
    public MyException(String message, int code,Object data) {
        this(message,null,data,code,null);
    }

    /**
    * Creates a new instance of MyException.
    * @param message 异常消息
    * @param cause 原异常
    * @param data 数据
     * @param code 代码
     * @param nbxx 内部信息
    */
    public MyException(String message, Throwable cause,Object data,int code,String nbxx) {
        super(message);
        initCause(cause);
        setData(data);
        setCode(code);
        if(cause!=null&&!MyException.class.isAssignableFrom(cause.getClass())){
            //异常状态且堆栈不为空，且不是已经被本系统处理后，自动打印异常信息
            if(code==HttpURLConnection.HTTP_INTERNAL_ERROR){
                log.error(nbxx,this);
            }else if(code!=HttpURLConnection.HTTP_OK){
                log.debug(nbxx,this);
            }
        }
    }
    /**
     * @return data
     */
    public Object getData() {
        return data;
    }

    /**
     * @param data the data to set
     */
    public void setData(Object data) {
        this.data = data;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    /**
     * @return 转为一般请求结果对象
     */
    public Result getResult(){
        String msg = getMessage();
        Result r = new Result(getCode() == HttpURLConnection.HTTP_OK,msg, JsonUtil.clone(data));
        r.setCode(getCode());
        return r;
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if(getCause()!=this&&getCause()!=null){
            //含子异常时，返回消息追加子异常消息
            msg += "->"+getCause().getMessage();
        }
        return msg;
    }
}
