/**
* by jingma 2018-12-12
*/
package cn.benma666.domain;

import cn.benma666.dict.Zdlb;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.DictManager;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.SjsjEntity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import org.beetl.sql.clazz.kit.StringKit;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.math.BigDecimal;

/**
 * 系统-数据管理-数据对象
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "SYS_SJGL_SJDX")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysSjglSjdx extends BasicBean{

	/**
	 * 序列化
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("ID")
	private String id;
	/**
	 * 排序
	 */
	@Column("PX")
	private BigDecimal px;
	/**
	 * 编辑页面扩展;涵盖新增、修改、详情
	 */
	@Column("BJYMKZ")
	private String bjymkz;
	/**
	 * 对象代码;代表唯一数据对象，多处使用，唯一
	 */
	@Column("DXDM")
	private String dxdm;
	/**
	 * 对象简拼
	 */
	@Column("DXJP")
	private String dxjp;
	/**
	 * 创建时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 对象描述
	 */
	@Column("DXMS")
	private String dxms;
	/**
	 * 批量页面扩展;主要用于扩展批量上传页面
	 */
	@Column("PLYMKZ")
	private String plymkz;
	/**
	 * 有效性字段;做逻辑删除等
	 */
	@Column("YXXZD")
	private String yxxzd;
	/**
	 * 列表复选框@SYS_COMMON_LJPD;控制是否展示
	 */
	@Column("LBFXK")
	private String lbfxk;
	/**
	 * 初始查询@SYS_COMMON_LJPD;控制查询页面是否初始化查询
	 */
	@Column("CSCX")
	private String cscx;
	/**
	 * SQL模板;用于扩展后端，基于beetl实现
	 */
	@Column("SQLMB")
	private String sqlmb;
	/**
	 * 创建人姓名
	 */
	@Column("CJRXM")
	private String cjrxm;
	/**
	 * 去重字段;用于插入更新
	 */
	@Column("QCZD")
	private String qczd;
	/**
	 * 查询列表扩展;可以扩展成各种基于数据查询的展示页面。
	 */
	@Column("CXLBKZ")
	private String cxlbkz;
	/**
	 * 创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("CJRDWDM")
	private String cjrdwdm;
	/**
	 * 增量字段;进行增量抽取等
	 */
	@Column("ZLZD")
	private String zlzd;
	/**
	 * 创建人单位名称
	 */
	@Column("CJRDWMC")
	private String cjrdwmc;
	/**
	 * 属性选择@SYS_COMMON_LJPD;控制是否展示
	 */
	@Column("SXXZ")
	private String sxxz;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("YXX")
	private String yxx;
	/**
	 * 对象载体;根据对象载体类型不同，表示不同的具体载体，如具体数据库、ftp等
	 */
	@Column("DXZT")
	private String dxzt;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("KZXX")
	private String kzxx;
	/**
	 * 对象类型@SYS_SJGL_DXLX;表、视图、excel、txt等
	 */
	@Column("DXLX")
	private String dxlx;
	/**
	 * 字段导入SQL;用于刷新对象字段
	 */
	@Column("ZDDRSQL")
	private String zddrsql;
	/**
	 * 主键字段;用于查询详情等
	 */
	@Column("ZJZD")
	private String zjzd;
	/**
	 * 编辑序号@SYS_COMMON_LJPD;控制是否显示编辑页面的字段序号
	 */
	@Column("BJXH")
	private String bjxh;
	/**
	 * 拦截器;后台扩展系统
	 */
	@Column("LJQ")
	private String ljq;
	/**
	 * 权限字段;进行权限控制
	 */
	@Column("QXZD")
	private String qxzd;
	/**
	 * 详情按钮@SYS_COMMON_LJPD;控制是否展示
	 */
	@Column("XQAN")
	private String xqan;
	/**
	 * 分页统计形式@SYS_SJGL_FYTJXS;控制分页查询数据量统计形式，如：默认形式、异步统计、默认不统计
	 */
	@Column("FYTJXS")
	private String fytjxs;
	/**
	 * 对象类别@SYS_SJGL_DXLB;标准对象、临时对象、系统对象等人工分类
	 */
	@Column("DXLB")
	private String dxlb;
	/**
	 * 对象全拼
	 */
	@Column("DXQP")
	private String dxqp;
	/**
	 * 查询条件@SYS_COMMON_LJPD;控制是否展示
	 */
	@Column("CXTJ")
	private String cxtj;
	/**
	 * 具体对象;数据库的表视图、文件名、文件正则等
	 */
	@Column("JTDX")
	private String jtdx;
	/**
	 * 对象归属;数据库的某个用户、ftp的目录等
	 */
	@Column("DXGS")
	private String dxgs;
	/**
	 * 创建人代码@SYS_COMMON_USER
	 */
	@Column("CJRDM")
	private String cjrdm;
	/**
	 * 资源等级@SYS_SJGL_ZYGJ;从高到低为1~10，按每三级分为高中低，一些较少使用的资源就设置为10级，10级默认不使用，需要使用时，需要特殊配置，系统默认6级
	 */
	private String zydj;
	/**
	 * 对象载体类型@SYS_SJGL_DXZTLX;ORACLE、POSTGRESS、MYSQL、GREEPLAM、本地文件、FTP文件、FASTDFS文件、SOLR、ES、HIVE、HBASE等
	 */
	@Transient
	private String dxztlx;
	/**
	 * 对象作用@SYS_SJGL_DXZY;增量导出、数据插入、数据更新、页面查询、页面新增、页面修改等
	 */
	@Column("DXZY")
	private String dxzy;
	/**
	 * 批次字段;用于存放批次号，知道具体数据来自哪次抽取等
	 */
	@Column("PCZD")
	private String pczd;
	/**
	 * 默认排序;查询时的默认排序规则
	 */
	@Column("MRPX")
	private String mrpx;
	/**
	 * 校验字段;用于存放校验信息
	 */
	@Column("JYZD")
	private String jyzd;
	/**
	 * 更新时间
	 */
	@Column("GXSJ")
	private String gxsj;
	/**
	 * 对象名称
	 */
	@Column("DXMC")
	private String dxmc;
	/**
	 * 数据载体
	 */
	@Transient
	@JSONField(serialize=false)
	private SysSjglSjzt sjztObj;
	/**
	 * 扩展信息对象
	 */
	@Transient
	@JSONField(serialize=false)
	private JSONObject kzxxObj = new JSONObject();
	/**
	 * 权限码
	 */
	@Transient
	private String authCode;
	/**
	 * 代码后缀
	 */
	@Transient
	private String dmhz;
	/**
	 * 名称后缀
	 */
	@Transient
	private String mchz;

	public void setKzxx(String kzxx) {
		this.kzxx = kzxx;
		//解析扩展信息
		if(StringUtil.isNotBlank(kzxx)&&StringUtil.isBlank(kzxxObj)){
			setKzxxObj(JSON.parseObject(kzxx, Feature.OrderedField));
		}
	}

	public void setDxzt(String dxzt) {
		this.dxzt = dxzt;
		//设置数据载体
		JSONObject dbObj = DictManager.zdObjByDm(Zdlb.SYS_COMMON_SJZT.name(), dxzt);
		if(dbObj==null){
			throw new MyException("没有找到数据载体："+dxzt);
		}
		setSjztObj(dbObj.toJavaObject(SysSjglSjzt.class));
		setDxztlx(getSjztObj().getLx());
	}

	public void setDxztlx(String dxztlx) {
		if(StringUtil.isNotBlank(dxztlx)){
			this.dxztlx = dxztlx;
		}
	}

	/**
	 * 自动根据实体类注解的表名转为大写得到对象代码
	 * @param t 类
	 * @param <T> 泛型
	 */
	public <T extends BasicBean> void szDxdmByBean(Class<T> t) {
		dxdm = beanToDxdm(t);
	}

	public String getZddmQczd(){
		if(StringUtil.isBlank(getQczd())){
			return getQczd();
		}
		return StringKit.deCodeUnderlined(getQczd());
	}
	public String getZddmZjzd(){
		if(StringUtil.isBlank(getZjzd())){
			return getZjzd();
		}
		return StringKit.deCodeUnderlined(getZjzd());
	}
	public String getZddmZlzd(){
		if(StringUtil.isBlank(getZlzd())){
			return getZlzd();
		}
		return StringKit.deCodeUnderlined(getZlzd());
	}
	public String getZddmYxx(){
		if(StringUtil.isBlank(getYxxzd())){
			return getYxxzd();
		}
		return StringKit.deCodeUnderlined(getYxxzd());
	}
}
