/**
* by jingma 2019-04-18
*/
package cn.benma666.domain;

import cn.benma666.constants.UtilConst;
import cn.benma666.dict.Xzms;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.Conf;
import cn.benma666.myutils.DateUtil;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.DbFile;
import cn.benma666.sjzt.IFile;
import cn.benma666.sjzt.SjsjEntity;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.beetl.sql.annotation.entity.Column;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;

/**
 * 系统-数据管理-文件
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "SYS_SJGL_FILE")
@Setter
@Getter
@NoArgsConstructor
@Builder
@SjsjEntity
@Slf4j
public class SysSjglFile extends BasicBean{

	/**
	 * 序列化
	 */
	private static final long serialVersionUID = 1L;

	public SysSjglFile(String sclj, String sjzt) {
		setSclj(sclj);
		this.sjzt = sjzt;
	}

	public SysSjglFile(String id, String cjrdwmc, String wjlx, String cjrxm, String gxsj, String ywdm, String glid,
					   String sclj, String cjsj, String kzxx, String wjm, String cjrdwdm, BigDecimal px, Integer wjdx,
					   String cjrdm, String wjlb, String sjzt, String qcm, String yxx,String sjdj, int xzms, String wjnr, String parent,
					   boolean arqfwjj, boolean wjmjhz, byte[] bytes,String zjfwdz) {
		this.id = id;
		this.cjrdwmc = cjrdwmc;
		this.wjlx = wjlx;
		this.cjrxm = cjrxm;
		this.gxsj = gxsj;
		this.ywdm = ywdm;
		this.glid = glid;
		setSclj(sclj);
		this.cjsj = cjsj;
		this.kzxx = kzxx;
		setWjm(wjm);
		this.cjrdwdm = cjrdwdm;
		this.px = px;
		this.wjdx = wjdx;
		this.cjrdm = cjrdm;
		this.wjlb = wjlb;
		this.sjzt = sjzt;
		this.qcm = qcm;
		this.yxx = yxx;
		this.sjdj = sjdj;
		this.xzms = xzms;
		this.wjnr = wjnr;
		this.parent = parent;
		this.arqfwjj = arqfwjj;
		this.wjmjhz = wjmjhz;
		this.bytes = bytes;
		this.zjfwdz = zjfwdz;
	}

	/**
     * 主键
     */
    @Id
    @GeneratedValue(generator="idGenerator")
    @Column("ID")
    private String id;

    /**
	 * 创建人单位名称
	 */
	@Column("CJRDWMC")
	private String cjrdwmc;
	/**
	 * 文件类型
	 */
	@Column("WJLX")
	private String wjlx;
	/**
	 * 创建人姓名
	 */
	@Column("CJRXM")
	private String cjrxm;
	/**
	 * 更新时间
	 */
	@Column("GXSJ")
	private String gxsj;
	/**
	 * 业务代码;ZDRY_RYGL
	 */
	@Column("YWDM")
	private String ywdm;
	/**
	 * 关联id;前端传
	 */
	@Column("GLID")
	private String glid;
	/**
	 * 上传路径;ZDRY_RYGL/去重码.wjlx
	 */
	@Column("SCLJ")
	private String sclj;
	/**
	 * 创建时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("KZXX")
	private String kzxx;
	/**
	 * 文件名
	 */
	@Column("WJM")
	private String wjm;
	/**
	 * 创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("CJRDWDM")
	private String cjrdwdm;
	/**
	 * 排序
	 */
	@Column("PX")
	private BigDecimal px;
    /**
     * 文件大小
     */
    @Column("WJDX")
    private Integer wjdx;
	/**
	 * 创建人代码@SYS_COMMON_USER
	 */
	@Column("CJRDM")
	private String cjrdm;
	/**
	 * 文件类别
	 */
	@Column("WJLB")
	private String wjlb;
	/**
	 * 数据载体
	 */
	@Column("SJZT")
	private String sjzt;
	/**
	 * 去重码
	 */
	@Column("QCM")
	private String qcm;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("YXX")
	private String yxx;
	/**
	 * 数据等级
	 */
	private String sjdj;
	/**
	* 下载模式，1：按文件类型下载、2：二进制文件下载、3：base64、4：转为base64后作为data以json对象返回
	*/
	@Transient
	@JSONField(serialize = false)
	private int xzms = Xzms.AWJLXXZ.getCode();
	/**
	 * 文件内容
	 */
	@Transient
	private String wjnr;
	/**
	 * 父路径
	 */
	private String parent;
	/**
	 * 按日期分文件夹
	 */
	@Transient
	@JSONField(serialize = false)
	private boolean arqfwjj = true;
	/**
	 * 文件名加后缀
	 */
	@Transient
	@JSONField(serialize = false)
	private boolean wjmjhz = true;
	/**
	 * 数据数组
	 */
	@Transient
	@JSONField(serialize = false)
	private byte[] bytes;

	@Transient
	private String zjfwdz;

	/**
	 * 获取该文件的二进制数据
	 */
	@JSONField(serialize = false)
	public byte[] getFileBytes() {
		InputStream in = null;
		try {
			in = getInputStream();
			return Utils.readByteArray(in);
		} catch (IOException e) {
			log.error("文件读取异常："+this,e);
			throw new MyException("文件读取异常："+e.getMessage(),e);
		}finally {
			FileUtil.closeStream(in);
		}
	}

	/**
	 * 获取文件输入流
	 */
	@JSONField(serialize = false)
	public InputStream getInputStream(){
		try {
			return toIFile().getInputStream();
		} catch (Exception e) {
			throw new MyException("文件读取异常："+ this.getSclj(),e);
		}
	}

	/**
	 * 删除文件
	 */
	public boolean delete(){
		//数据载体为本地文件时
		try {
			return toIFile().delete();
		} catch (Exception e) {
			throw new MyException("文件没有找到："+ this.getSclj());
		}
	}
	public IFile toIFile(){
		if(StringUtil.isBlank(getId())){
			//id为空表示新增场景
			setId(StringUtil.getUUIDUpperStr());
		}
		DbFile ifile = new DbFile(this);
		return ifile;
	}

	/**
	 * @return 获取直接访问地址，不支持的则返回文件id
	 */
	public String getZjfwdz(){
		if(StringUtil.isNotBlank(zjfwdz)){
			return zjfwdz;
		}
		IFile iFile = toIFile();
		if(iFile.zcUrl()){
			return iFile.getUrl();
		}else {
			return getId();
		}
	}

	public void setSclj(String sclj) {
		this.sclj = sclj;
		if(StringUtil.isBlank(sclj)){
			return;
		}
		File f = new File(sclj);
		if(StringUtil.isBlank(getWjm())){
			setWjm(f.getName());
		}
	}

	public void setWjm(String wjm) {
		this.wjm = wjm;
		if(StringUtil.isBlank(getWjlx())&&wjm.contains(".")){
			setWjlx(wjm.substring(wjm.lastIndexOf(".")+1).toLowerCase());
		}
	}

	@JSONField(serialize = false)
	public String getParentNew() {
		if(StringUtil.isNotBlank(parent)){
			return parent;
		}
		String parent = "";
		if(StringUtil.isNotBlank(getYwdm())){
			parent += getYwdm() + UtilConst.FXG;
		}
		if(StringUtil.isNotBlank(getWjlb())){
			parent += getWjlb() + UtilConst.FXG;
		}
		if (isArqfwjj()) {
			//指定设置要求不按日期分文件夹
			parent += DateUtil.getDateTimeStr(DateUtil.DATE_FORMATTER8) + UtilConst.FXG;
		}
		return parent;
	}

	@JSONField(serialize = false)
	public String getSjztNew() {
		if (StringUtil.isBlank(sjzt)) {
			//设置默认数据载体
			sjzt = Conf.getVal("wjsc.mrsjzt");
		}
		return sjzt;
	}

	/**
	 * @return 返回给web前端的对象，只返回必要属性
	 */
	public SysSjglFile toQd(){
		return SysSjglFile.builder().wjdx(getWjdx()).wjm(getWjm())
				.zjfwdz(getZjfwdz()).id(getId()).build();
	}
}
