/**
* by jingma 2018-12-19
*/
package cn.benma666.domain;

import cn.benma666.sjzt.SjsjEntity;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.math.BigDecimal;

/**
 * 系统-权限-机构信息
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "SYS_QX_JGXX")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysQxJgxx extends BasicBean{

	/**
	 * 序列化
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("ID")
	private String id;
	/**
	 * 机构简称
	 */
	@Column("JGJC")
	private String jgjc;
	/**
	 * 创建时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 机构代码
	 */
	@Column("JGDM")
	private String jgdm;
	/**
	 * 上级机构
	 */
	@Column("SJJG")
	private String sjjg;
	/**
	 * 机构描述
	 */
	@Column("JGMS")
	private String jgms;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("KZXX")
	private String kzxx;
	/**
	 * 备注
	 */
	@Column("BZ")
	private String bz;
	/**
	 * 机构类型
	 */
	@Column("JGLX")
	private String jglx;
	/**
	 * 创建人代码@SYS_COMMON_USER
	 */
	@Column("CJRDM")
	private String cjrdm;
	/**
	 * 简称简拼
	 */
	@Column("JCJP")
	private String jcjp;
	/**
	 * 机构地址
	 */
	@Column("JGDZ")
	private String jgdz;
	/**
	 * 机构邮箱
	 */
	@Column("JGYX")
	private String jgyx;
	/**
	 * 机构别名
	 */
	@Column("JGBM")
	private String jgbm;
	/**
	 * 更新时间
	 */
	@Column("GXSJ")
	private String gxsj;
	/**
	 * 名称简拼
	 */
	@Column("MCJP")
	private String mcjp;
	/**
	 * 创建人姓名
	 */
	@Column("CJRXM")
	private String cjrxm;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("YXX")
	private String yxx;
	/**
	 * 创建人单位名称
	 */
	@Column("CJRDWMC")
	private String cjrdwmc;
	/**
	 * 排序
	 */
	@Column("PX")
	private BigDecimal px;
	/**
	 * 联系人电话
	 */
	@Column("LXRDH")
	private String lxrdh;
	/**
	 * 联系人
	 */
	@Column("LXR")
	private String lxr;
	/**
	 * 机构层级
	 */
	@Column("JGCJ")
	private BigDecimal jgcj;
	/**
	 * 创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("CJRDWDM")
	private String cjrdwdm;
	/**
	 * 机构名称
	 */
	@Column("JGMC")
	private String jgmc;

	/**
	 * @return 主键
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id 主键
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return 机构简称
	 */
	public String getJgjc() {
		return jgjc;
	}
	/**
	 * @param jgjc 机构简称
	 */
	public void setJgjc(String jgjc) {
		this.jgjc = jgjc;
	}

	/**
	 * @return 创建时间
	 */
	public String getCjsj() {
		return cjsj;
	}
	/**
	 * @param cjsj 创建时间
	 */
	public void setCjsj(String cjsj) {
		this.cjsj = cjsj;
	}

	/**
	 * @return 机构代码
	 */
	public String getJgdm() {
		return jgdm;
	}
	/**
	 * @param jgdm 机构代码
	 */
	public void setJgdm(String jgdm) {
		this.jgdm = jgdm;
	}

	/**
	 * @return 上级机构
	 */
	public String getSjjg() {
		return sjjg;
	}
	/**
	 * @param sjjg 上级机构
	 */
	public void setSjjg(String sjjg) {
		this.sjjg = sjjg;
	}

	/**
	 * @return 机构描述
	 */
	public String getJgms() {
		return jgms;
	}
	/**
	 * @param jgms 机构描述
	 */
	public void setJgms(String jgms) {
		this.jgms = jgms;
	}

	/**
	 * @return 扩展信息;JSON格式
	 */
	public String getKzxx() {
		return kzxx;
	}
	/**
	 * @param kzxx 扩展信息;JSON格式
	 */
	public void setKzxx(String kzxx) {
		this.kzxx = kzxx;
	}

	/**
	 * @return 备注
	 */
	public String getBz() {
		return bz;
	}
	/**
	 * @param bz 备注
	 */
	public void setBz(String bz) {
		this.bz = bz;
	}

	/**
	 * @return 机构类型
	 */
	public String getJglx() {
		return jglx;
	}
	/**
	 * @param jglx 机构类型
	 */
	public void setJglx(String jglx) {
		this.jglx = jglx;
	}

	/**
	 * @return 创建人代码@SYS_COMMON_USER
	 */
	public String getCjrdm() {
		return cjrdm;
	}
	/**
	 * @param cjrdm 创建人代码@SYS_COMMON_USER
	 */
	public void setCjrdm(String cjrdm) {
		this.cjrdm = cjrdm;
	}

	/**
	 * @return 简称简拼
	 */
	public String getJcjp() {
		return jcjp;
	}
	/**
	 * @param jcjp 简称简拼
	 */
	public void setJcjp(String jcjp) {
		this.jcjp = jcjp;
	}

	/**
	 * @return 机构地址
	 */
	public String getJgdz() {
		return jgdz;
	}
	/**
	 * @param jgdz 机构地址
	 */
	public void setJgdz(String jgdz) {
		this.jgdz = jgdz;
	}

	/**
	 * @return 机构邮箱
	 */
	public String getJgyx() {
		return jgyx;
	}
	/**
	 * @param jgyx 机构邮箱
	 */
	public void setJgyx(String jgyx) {
		this.jgyx = jgyx;
	}

	/**
	 * @return 机构别名
	 */
	public String getJgbm() {
		return jgbm;
	}
	/**
	 * @param jgbm 机构别名
	 */
	public void setJgbm(String jgbm) {
		this.jgbm = jgbm;
	}

	/**
	 * @return 更新时间
	 */
	public String getGxsj() {
		return gxsj;
	}
	/**
	 * @param gxsj 更新时间
	 */
	public void setGxsj(String gxsj) {
		this.gxsj = gxsj;
	}

	/**
	 * @return 名称简拼
	 */
	public String getMcjp() {
		return mcjp;
	}
	/**
	 * @param mcjp 名称简拼
	 */
	public void setMcjp(String mcjp) {
		this.mcjp = mcjp;
	}

	/**
	 * @return 创建人姓名
	 */
	public String getCjrxm() {
		return cjrxm;
	}
	/**
	 * @param cjrxm 创建人姓名
	 */
	public void setCjrxm(String cjrxm) {
		this.cjrxm = cjrxm;
	}

	/**
	 * @return 有效性@SYS_COMMON_LJPD
	 */
	public String getYxx() {
		return yxx;
	}
	/**
	 * @param yxx 有效性@SYS_COMMON_LJPD
	 */
	public void setYxx(String yxx) {
		this.yxx = yxx;
	}

	/**
	 * @return 创建人单位名称
	 */
	public String getCjrdwmc() {
		return cjrdwmc;
	}
	/**
	 * @param cjrdwmc 创建人单位名称
	 */
	public void setCjrdwmc(String cjrdwmc) {
		this.cjrdwmc = cjrdwmc;
	}

	/**
	 * @return 排序
	 */
	public BigDecimal getPx() {
		return px;
	}
	/**
	 * @param px 排序
	 */
	public void setPx(BigDecimal px) {
		this.px = px;
	}

	/**
	 * @return 联系人电话
	 */
	public String getLxrdh() {
		return lxrdh;
	}
	/**
	 * @param lxrdh 联系人电话
	 */
	public void setLxrdh(String lxrdh) {
		this.lxrdh = lxrdh;
	}

	/**
	 * @return 联系人
	 */
	public String getLxr() {
		return lxr;
	}
	/**
	 * @param lxr 联系人
	 */
	public void setLxr(String lxr) {
		this.lxr = lxr;
	}

	/**
	 * @return 机构层级
	 */
	public BigDecimal getJgcj() {
		return jgcj;
	}
	/**
	 * @param jgcj 机构层级
	 */
	public void setJgcj(BigDecimal jgcj) {
		this.jgcj = jgcj;
	}

	/**
	 * @return 创建人单位代码@SYS_COMMON_ORG
	 */
	public String getCjrdwdm() {
		return cjrdwdm;
	}
	/**
	 * @param cjrdwdm 创建人单位代码@SYS_COMMON_ORG
	 */
	public void setCjrdwdm(String cjrdwdm) {
		this.cjrdwdm = cjrdwdm;
	}

	/**
	 * @return 机构名称
	 */
	public String getJgmc() {
		return jgmc;
	}
	/**
	 * @param jgmc 机构名称
	 */
	public void setJgmc(String jgmc) {
		this.jgmc = jgmc;
	}

}
