/**
* by jingma 2022-10-26
*/
package cn.benma666.domain;

import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.SjsjEntity;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.math.BigDecimal;

/**
 * 系统-平台管理-系统消息
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "sys_ptgl_xtxx")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysPtglXtxx extends BasicBean{
	/**
	 * 消息类别-刷新消息
	 */
	public final static String XXLB_SXXX = "00";
	/**
	 * 消息类别-通知公告
	 */
	public final static String XXLB_TZGG = "01";
	/**
	 * 消息类别-其他消息
	 */
	public final static String XXLB_QTXX = "99";
	/**
	 * 平台通知消息的消息大类
	 */
	public static final String SYS_PTGL_XTXX = "SYS_PTGL_XTXX";

	/**
	 * 主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("id")
	private String id;
	/**
	 * 消息内容
	 */
	@Column("xxnr")
	private String xxnr;
	/**
	 * 消息类别@SYS_PTGL_XTXX_XXLB;默认其他消息
	 */
	@Column("xxlb")
	private String xxlb=XXLB_QTXX;
	/**
	 * 接收单位
	 */
	@Column("jsdw")
	private String jsdw;
	/**
	 * 接收人
	 */
	@Column("jsr")
	private String jsr;
	/**
	 * 已读状态@SYS_COMMON_LJPD;0未读，1已读
	 */
	@Column("ydzt")
	private int ydzt;
	/**
	 * 创建时间
	 */
	@Column("cjsj")
	private String cjsj;
	/**
	 * 更新时间
	 */
	@Column("gxsj")
	private String gxsj;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("yxx")
	private String yxx;
	/**
	 * 排序
	 */
	@Column("px")
	private BigDecimal px;
	/**
	 * 扩展信息
	 */
	@Column("kzxx")
	private String kzxx;
	/**
	 * 创建人姓名
	 */
	@Column("cjrxm")
	private String cjrxm;
	/**
	 * 创建人代码@SYS_COMMON_USER
	 */
	@Column("cjrdm")
	private String cjrdm;
	/**
	 * 创建人单位名称
	 */
	@Column("cjrdwmc")
	private String cjrdwmc;
	/**
	 * 创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("cjrdwdm")
	private String cjrdwdm;
	/**
	 * 目的地大类-对象代码
	 */
	@Transient
	private String mdddl;
	/**
	 * 目的地小类-记录主键
	 */
	@Transient
	private String mddxl;
	/**
	 * 消息等级@SYS_COMMON_DJ
	 */
	@Column("xxdj")
	private String xxdj;
	/**
	 * 推送会话
	 */
	@Transient
	private String tshh;

	/**
	 * @return 消息目的地代码
	 */
	public String getMdd() {
		if(StringUtil.isNotBlank(mdddl)&&StringUtil.isNotBlank(mddxl)){
			return mdddl+"_"+mddxl;
		}else if(StringUtil.isNotBlank(mdddl)){
			return mdddl;
		}
		return SYS_PTGL_XTXX;
	}
}
