/**
* by jingma 2018-12-20
*/
package cn.benma666.domain;

import cn.benma666.sjzt.SjsjEntity;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

/**
 * 系统-日志-访问日志
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "SYS_LOG_FWZR")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysLogFwzr extends BasicBean{

	/**
	 * 创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("CJRDWDM")
	private String cjrdwdm;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("KZXX")
	private String kzxx;
	/**
	 * 操作ip
	 */
	@Column("CZIP")
	private String czip;
	/**
	 * 创建人代码@SYS_COMMON_USER
	 */
	@Column("CJRDM")
	private String cjrdm;
	/**
	 * 权限id
	 */
	@Column("TOKEN")
	private String token;
	/**
	 * URL
	 */
	@Column("URL")
	private String url;
	/**
	 * 主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("ID")
	private String id;
	/**
	 * 操作类型
	 */
	@Column("CZLX")
	private String czlx;
	/**
	 * 相关参数
	 */
	@Column("XGCS")
	private String xgcs;
	/**
	 * 创建人姓名
	 */
	@Column("CJRXM")
	private String cjrxm;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("YXX")
	private String yxx;
	/**
	 * 数据对象
	 */
	@Column("SJDX")
	private String sjdx;
	/**
	 * 排序
	 */
	@Column("PX")
	private int px;
	/**
	 * 创建人单位名称
	 */
	@Column("CJRDWMC")
	private String cjrdwmc;
	/**
	 * 创建时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 更新时间
	 */
	@Column("GXSJ")
	private String gxsj;
    /**
     * 数据记录;对应操作记录的主键
     */
    @Column("SJJL")
    private String sjjl;
	/**
	 * 返回内容;不保存data
	 */
	@Column("FHNR")
	private String fhnr;
	/**
	 * 请求耗时
	 */
	@Column("QQHS")
	private long qqhs;
	/**
	 * 返回结果
	 */
	@Column("FHJG")
	private int fhjg;
	/**
	 * 返回代码
	 */
	@Column("FHDM")
	private String fhdm;
	/**
	 * 返回消息
	 */
	@Column("FHXX")
	private String fhxx;
	/**
	 * 菜单路径
	 */
	@Column("CDLJ")
	private String cdlj;
	/**
	 * 操作类型名称
	 */
	@Column("CZLXMC")
	private String czlxmc;
	/**
	 * 调度节点
	 */
	@Column("DDJD")
	private String ddjd;
}
