package cn.benma666.dict;

import cn.benma666.exception.MyException;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 逻辑判断
 */
@Getter
public enum Xzms {
    /**
     * 文件-下载模式-按文件类型下载
     */
    AWJLXXZ(1),
    /**
     * 文件-下载模式-二进制文件下载
     */
    EJZ(2),
    /**
     * 文件-下载模式-base64
     */
    BASE64(3),
    /**
     * 文件-下载模式-转为base64后作为data以json对象返回
     */
    BASE64OBJ(4);
    private static Map<Integer,Xzms> map = new HashMap<>();
    private final int code;
    Xzms(int code){
        this.code = code;
    }

    public static Xzms getByCode(int code) {
        for (Xzms v : values()) {
            if (v.getCode()==code) {
                return v;
            }
        }
        throw new MyException("不支持的下载模式："+code);
    }
}
