/**
* Project Name:myutils
* Date:2021年5月14日
* Copyright (c) 2021, jingma All Rights Reserved.
*/

package cn.benma666.crypt;

import java.security.MessageDigest;

/**
 *  <br/>
 * date: 2021年5月14日 <br/>
 * @author jingma
 * @version 
 */
public class SHA256 {
    public static void main(String[] args) throws Exception {
        System.out.println(encode("xxxwew额范文芳威锋网xxwew额范文芳威锋网xxwew额范文芳威锋网xxwew额范文芳威锋网xxwe"
                + "w额范文芳威锋网xxwew额范文芳威锋网xxwew额范文芳威锋网xxwew额范文芳威锋网xxwew额范文芳威锋网"));
    }

    /**
     * 利用java原生的类实现SHA256加密
     *
     * @param str 参数拼接的字符串
     * @return
     * @throws Exception 
     */
    public static String encode(String str) throws Exception {
        MessageDigest messageDigest;
        String encodeStr = "";
        messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(str.getBytes("UTF-8"));
        encodeStr = byte2Hex(messageDigest.digest());
        return encodeStr;
    }

    /**
     * 将byte转为16进制
     *
     * @param bytes
     * @return
     */
    private static String byte2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        String temp = null;
        for (byte aByte : bytes) {
            temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                // 1得到一位的进行补0操作
                sb.append("0");
            }
            sb.append(temp);
        }
        return sb.toString();
    }

}
