package cn.benma666.constants;

/**
 * 常量 <br/>
 * date: 2016年5月24日 下午7:18:51 <br/>
 * @author jingma
 * @version 0.2
 */
public interface UtilConstInstance {

    /**
    * 默认
    */
    String DEFAULT = "default";
    /**
     * 临时用户
     */
    String LSYH = "lsyh";
    /**
     * 系统最高用户
     */
    String SYS = "sys";

    /**
    * 空字符串
    */
    String NULL_STR = "";
    /**
     * 半角空格
     */
    String BLANK_SPACE = " ";
    /**
     * 全角空格
     */
    String SBC_BLANK_SPACE = " ";
    /**
    * 反斜杠
    */
    String FXG = "/";
    /**
    * 单引号
    */
    String DYH = "'";
    /**
    * 百分号
    */
    String BFH = "%";
    /**
    * 双竖线
    */
    String SSX = "||";
    /**
    * 特殊连接符，一般不会在常规字符串中出现
    */
    String TSLJF1 = "TSLJF1";
    /**
    * 特殊连接符，一般不会在常规字符串中出现
    */
    String TSLJF2 = "TSLJF2";
    /**
    * 临时对象前缀
    */
    String TEMP_ = "TEMP_";
    /**
    * 临时表变量名称
    */
    String TEMP_TABLE = "TEMP_TABLE";

    /**
     * 数据对象
     */
    String KEY_SJDX = "sjdx";
    /**
     * 系统参数
     */
    String KEY_SYS = "sys";
    /**
     * 数据对象
     */
    String KEY_PAGE = "page";
    /**
     * 数据对象
     */
    String KEY_OBJ = "obj";
    /**
     * 原数据对象，保存着前端传入的参数对象
     */
    String KEY_YOBJ = "yobj";
    /**
     * 用户信息
     */
    String KEY_USER = "user";
    /**
     * 字段对象集
     */
    String KEY_FIELDS = "fields";
    /**
     * 去重字段集合
     */
    String KEY_QCFIELDS = "qcFields";
    /**
     * 操作日志
     */
    String KEY_CZRZ = "czrz";
    /**
     * 验证规则key
     */
    String KEY_YZGZ = "yzgz";
    /**
     * 转换规则key
     */
    String KEY_ZHGZ = "zhgz";
    /**
     * 其他对象key，一般存放如http请求对象等第三方对象，完整输出参数对象时会移除该key
     */
    String KEY_OTHEROBJ = "other";
    /**
     * 智能交换key
     */
    String KEY_ZNJH = "znjh";
    /**
     * sql相关参数
     */
    String KEY_SQL = "sql";

    /**
     * jsonpath路径-处理类型的key
     */
    String $_SYS_CLLX = "$.sys.cllx";
    /**
     * jsonpath路径-客户端ip
     */
    String $_SYS_CLIENT_IP = "$.sys.clientIp";
    /**
     * jsonpath路径-参数体处理，用于某个操作完成后，关联进行的操作
     */
    String $_SYS_CSTCL = "$.sys.cstcl";
    /**
     * jsonpath路径-父数据对象代码
     */
    String $_SYS_FSJDXDM = "$.sys.fsjdxdm";
    /**
     * jsonpath路径-用户权限key
     */
    String $_SYS_TOKEN = "$.sys.token";
    /**
     * jsonpath路径-超时参数
     */
    String $_SYS_TIMEOUT = "$.sys.timeout";
    /**
     * jsonpath路径-权限代码
     */
    String $_SYS_AUTHCODE = "$.sys.authCode";
    /**
     * jsonpath路径-已找到记录
     */
    String $_SYS_YZDJL = "$.sys.yzdjl";
    /**
     * jsonpath路径-页面批量操作选择的记录id列表
     */
    String $_SYS_IDS = "$.sys.ids";
    /**
     * jsonpath路径-页面批量编辑的数据
     */
    String $_SYS_EDITTABLEDATA = "$.sys.editTableData";
    /**
     * jsonpath路径-回调参数体
     */
    String $_SYS_HDCST = "$.sys.hdcst";
}
