package cn.benma666.config;

import cn.benma666.domain.BasicBean;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.iframe.Conf;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * 数据世界配置
 */
@Setter
@Getter
public class Benma666 extends BasicBean {
    /**
     * websoket是否启用
     */
    private String webSocketEnabled;
    /**
     * 调试模式
     */
    private boolean debug;
    /**
     * 可以是springboot的bean名称（从容器中获取）或者具体的完整类路径（反射实例化，springboot的注解不会生效）
     */
    private String ljqDefault;
    /**
     * 授权模式，cllx（精确到处理类型），sjdx（只要相关数据对象有授权就可以使用其下所有方法），默认为cllx
     */
    private String xtqxSqms;
    /**
     * 配置的字典类别列表
     */
    private String configList;
    /**
     * 密码解密密码
     */
    private String fwqEjmm;
    /**
     * 密码解密密码
     */
    private String sjztEjmm;
    /**
     * 用户目前采用md5加密不需要设置密码
     */
    private String yhxxEjmm;
    /**
     * 密码解密密码
     */
    private String appEjmm;
    /**
     * 应用代码，没有应用都要独立的应用代码，与应用管理中的代码一致
     */
    private String appDm;
    /**
     * 登录配置
     */
    private Login login;
    /**
     * 数据相关
     */
    private Data data;
    /**
     * 智能交换
     */
    private Znjh znjh;
    /**
     * kettle-manager配置
     */
    private Km km;
    /**
     * 出默认数据源外的数据源
     */
    private Map<String, SysSjglSjzt> datasource = new HashMap<>();
    /**
     * 服务相关配置
     */
    private Service service;
    public Benma666() {
        Conf.setUtilConfig(this);
    }
}
