/*
* Project Name:myutils
* Date:2018年11月30日
* Copyright (c) 2018, jingma All Rights Reserved.
*/
package cn.benma666.beetl;

import cn.benma666.exception.MyException;
import cn.hutool.log.LogFactory;
import org.beetl.core.ConsoleErrorHandler;
import org.beetl.core.GroupTemplate;
import org.beetl.core.exception.BeetlException;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

/**
 * 重新抛出beetl渲染异常 <br/>
 * date: 2018年11月30日 <br/>
 * @author jingma
 * @version 0.1
 */
public class ReThrowErrorHandler extends ConsoleErrorHandler{
    @Override
    public void processException(BeetlException ex, GroupTemplate groupTemplate, Writer writer)
    {
        StringWriter w = new StringWriter();
        super.processException(ex, groupTemplate, w);
        LogFactory.get().error(w.toString(),ex);
        throw new MyException( w.toString(),ex);
    }
    /**
    *
    * @see org.beetl.core.ConsoleErrorHandler#print(java.io.Writer, java.lang.String)
    */
    @Override
    protected void print(Writer w, String msg) {
        try {
            w.append(msg);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    /**
    *
    * @see org.beetl.core.ConsoleErrorHandler#println(java.io.Writer, java.lang.String)
    */
    @Override
    protected void println(Writer w, String msg) {
        print(w, msg+File.separator);
    }


}
