package cn.benma666.sm;

import cn.benma666.myutils.ByteUtil;
import com.alibaba.druid.util.Utils;
import lombok.Setter;
import org.apache.commons.net.util.Base64;

import java.io.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
* 与DES对应的国产对称加密算法 <br/>
* date: 2021年9月12日 <br/>
* @author jingma
* @version 0.2
*/
@SuppressWarnings("restriction")
@Setter
public class SM4 {
	private String secretKey = "";
	private String iv = "";
	private boolean hexString = false;

	public static void main(String[] args) throws IOException {
		String plainText = "ererfeiisgod";
		SM4 sm4 = new SM4();
		sm4.secretKey = "JeF8U9wHFOMfs2Y8";
		sm4.hexString = false;

		System.out.println("ECB模式");
		String cipherText = sm4.encryptDataToString_ECB(plainText);
		System.out.println("密文: " + cipherText);
		System.out.println("");

		plainText = sm4.decryptDataToString_ECB(cipherText);
		System.out.println("明文: " + plainText);
		System.out.println("");

		System.out.println("CBC模式");
		sm4.iv = "UISwD9fW6cFh9SNS";
		cipherText = sm4.encryptDataToString_CBC(plainText);
		System.out.println("密文: " + cipherText);
		System.out.println("");

		plainText = sm4.decryptDataToString_CBC(cipherText);
		System.out.println("明文: " + plainText);
	}

	public String decryptDataToString_CBC(String cipherText) {
		return decryptDataToString_CBC(cipherText, "GBK");
	}

	public String decryptDataToString_CBC(String cipherText, String charset) {
		try {
			SM4_Context ctx = new SM4_Context();
			ctx.isPadding = true;
			ctx.mode = SM4Base.SM4_DECRYPT;

			byte[] keyBytes;
			byte[] ivBytes;
			if (hexString) {
				keyBytes = ByteUtil.hexStringToBytes(secretKey);
				ivBytes = ByteUtil.hexStringToBytes(iv);
			} else {
				keyBytes = secretKey.getBytes();
				ivBytes = iv.getBytes();
			}

			SM4Base sm4 = new SM4Base();
			sm4.sm4_setkey_dec(ctx, keyBytes);
			byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.decodeBase64(cipherText));
			return new String(decrypted, charset);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public byte[] decryptData_CBC(String cipherText) {
		try {
			SM4_Context ctx = new SM4_Context();
			ctx.isPadding = true;
			ctx.mode = SM4Base.SM4_DECRYPT;

			byte[] keyBytes;
			byte[] ivBytes;
			if (hexString) {
				keyBytes = ByteUtil.hexStringToBytes(secretKey);
				ivBytes = ByteUtil.hexStringToBytes(iv);
			} else {
				keyBytes = secretKey.getBytes();
				ivBytes = iv.getBytes();
			}

			SM4Base sm4 = new SM4Base();
			sm4.sm4_setkey_dec(ctx, keyBytes);
			return sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.decodeBase64(cipherText));
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public String decryptDataToString_CBC(byte[] bytes) {
		try {
			SM4_Context ctx = new SM4_Context();
			ctx.isPadding = true;
			ctx.mode = SM4Base.SM4_DECRYPT;

			byte[] keyBytes;
			byte[] ivBytes;
			if (hexString) {
				keyBytes = ByteUtil.hexStringToBytes(secretKey);
				ivBytes = ByteUtil.hexStringToBytes(iv);
			} else {
				keyBytes = secretKey.getBytes();
				ivBytes = iv.getBytes();
			}

			SM4Base sm4 = new SM4Base();
			sm4.sm4_setkey_dec(ctx, keyBytes);
			byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, bytes);
			return new String(decrypted, "GBK");
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public byte[] decryptData_ECB(byte[] bytes) {
		try {
			SM4_Context ctx = new SM4_Context();
			ctx.isPadding = true;
			ctx.mode = SM4Base.SM4_DECRYPT;

			byte[] keyBytes;
			if (hexString) {
				keyBytes = ByteUtil.hexStringToBytes(secretKey);
			} else {
				keyBytes = secretKey.getBytes();
			}

			SM4Base sm4 = new SM4Base();
			sm4.sm4_setkey_dec(ctx, keyBytes);
			return sm4.sm4_crypt_ecb(ctx, bytes);

		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public byte[] decryptData_ECB(String cipherText) {
		try {
			SM4_Context ctx = new SM4_Context();
			ctx.isPadding = true;
			ctx.mode = SM4Base.SM4_DECRYPT;

			byte[] keyBytes;
			if (hexString) {
				keyBytes = ByteUtil.hexStringToBytes(secretKey);
			} else {
				keyBytes = secretKey.getBytes();
			}

			SM4Base sm4 = new SM4Base();
			sm4.sm4_setkey_dec(ctx, keyBytes);
			return sm4.sm4_crypt_ecb(ctx, Base64.decodeBase64(cipherText));

		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public String decryptDataToString_ECB(String cipherText) {
		return decryptDataToString_ECB(cipherText, "GBK");
	}

	public String decryptDataToString_ECB(String cipherText, String charset) {
		try {
			SM4_Context ctx = new SM4_Context();
			ctx.isPadding = true;
			ctx.mode = SM4Base.SM4_DECRYPT;

			byte[] keyBytes;
			if (hexString) {
				keyBytes = ByteUtil.hexStringToBytes(secretKey);
			} else {
				keyBytes = secretKey.getBytes();
			}

			SM4Base sm4 = new SM4Base();
			sm4.sm4_setkey_dec(ctx, keyBytes);
			byte[] decrypted = sm4.sm4_crypt_ecb(ctx, Base64.decodeBase64(cipherText));
			return new String(decrypted, charset);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public String encryptDataToString_CBC(byte[] bytes) {
		try {
			SM4_Context ctx = new SM4_Context();
			ctx.isPadding = true;
			ctx.mode = SM4Base.SM4_ENCRYPT;

			byte[] keyBytes;
			byte[] ivBytes;
			if (hexString) {
				keyBytes = ByteUtil.hexStringToBytes(secretKey);
				ivBytes = ByteUtil.hexStringToBytes(iv);
			} else {
				keyBytes = secretKey.getBytes();
				ivBytes = iv.getBytes();
			}

			SM4Base sm4 = new SM4Base();
			sm4.sm4_setkey_enc(ctx, keyBytes);
			byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, bytes);
			String cipherText = Base64.encodeBase64String(encrypted);
			if (cipherText != null && cipherText.trim().length() > 0) {
				Pattern p = Pattern.compile("\\s*|\t|\r|\n");
				Matcher m = p.matcher(cipherText);
				cipherText = m.replaceAll("");
			}
			return cipherText;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public String encryptDataToString_CBC(String plainText) {
		return encryptDataToString_CBC(plainText, "GBK");
	}
	public String encryptDataToString_CBC(String plainText, String charset) {
		try {
			SM4_Context ctx = new SM4_Context();
			ctx.isPadding = true;
			ctx.mode = SM4Base.SM4_ENCRYPT;

			byte[] keyBytes;
			byte[] ivBytes;
			if (hexString) {
				keyBytes = ByteUtil.hexStringToBytes(secretKey);
				ivBytes = ByteUtil.hexStringToBytes(iv);
			} else {
				keyBytes = secretKey.getBytes();
				ivBytes = iv.getBytes();
			}

			SM4Base sm4 = new SM4Base();
			sm4.sm4_setkey_enc(ctx, keyBytes);
			byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes(charset));
			return getString(encrypted);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	private String getString(byte[] encrypted) {
		String cipherText = Base64.encodeBase64String(encrypted);
		if (cipherText != null && cipherText.trim().length() > 0) {
			Pattern p = Pattern.compile("\\s*|\t|\r|\n");
			Matcher m = p.matcher(cipherText);
			cipherText = m.replaceAll("");
		}
		return cipherText;
	}

	public byte[] encryptData_CBC(String plainText, String charset) {
		try {
			return encryptData_CBC(plainText.getBytes(charset));
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return null;
		}
	}

	public byte[] encryptData_CBC(byte[] bytes) {
		try {
			SM4_Context ctx = new SM4_Context();
			ctx.isPadding = true;
			ctx.mode = SM4Base.SM4_ENCRYPT;

			byte[] keyBytes;
			byte[] ivBytes;
			if (hexString) {
				keyBytes = ByteUtil.hexStringToBytes(secretKey);
				ivBytes = ByteUtil.hexStringToBytes(iv);
			} else {
				keyBytes = secretKey.getBytes();
				ivBytes = iv.getBytes();
			}

			SM4Base sm4 = new SM4Base();
			sm4.sm4_setkey_enc(ctx, keyBytes);
			return sm4.sm4_crypt_cbc(ctx, ivBytes, bytes);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public byte[] encryptData_ECB(byte[] bytes) {
//		SM4_Context ctx = new SM4_Context();
//		SM4Base sm4 = new SM4Base();
//		try {
//			return sm4.sm4_crypt_ecb(ctx, bytes);
//		} catch (Exception e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//			return null;
//		}

		try {
			SM4_Context ctx = new SM4_Context();
			ctx.isPadding = true;
			ctx.mode = SM4Base.SM4_ENCRYPT;

			byte[] keyBytes;
			if (hexString) {
				keyBytes = ByteUtil.hexStringToBytes(secretKey);
			} else {
				keyBytes = secretKey.getBytes();
			}

			SM4Base sm4 = new SM4Base();
			sm4.sm4_setkey_enc(ctx, keyBytes);
			return sm4.sm4_crypt_ecb(ctx, bytes);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public byte[] encryptData_ECB(File f) throws IOException {
		if(f.exists()) {
			InputStream inStream = new FileInputStream(f);
			return encryptData_ECB(Utils.readByteArray(inStream));
		} else {
			throw new IOException("File not Found");
		}

	}

	public byte[] encryptData_ECB(String plainText) {
		return encryptData_ECB(plainText, "GBK");
	}

	public byte[] encryptData_ECB(String plainText, String charset) {
		try {
			return encryptData_ECB(plainText.getBytes(charset));
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return null;
		}
	}

	public String encryptDataToString_ECB(String plainText) {
			return encryptDataToString_ECB(plainText, "GBK");
	}

    public String encryptDataToString_ECB(String plainText, String charset) {
		try {
			SM4_Context ctx = new SM4_Context();
			ctx.isPadding = true;
			ctx.mode = SM4Base.SM4_ENCRYPT;

			byte[] keyBytes;
			if (hexString) {
				keyBytes = ByteUtil.hexStringToBytes(secretKey);
			} else {
				keyBytes = secretKey.getBytes();
			}

			SM4Base sm4 = new SM4Base();
			sm4.sm4_setkey_enc(ctx, keyBytes);
			byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes(charset));
			return getString(encrypted);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public void setIv(String iv) {
		StringBuilder ivBuilder = new StringBuilder(iv);
		while (ivBuilder.length()<16){
			//不足16位补足
			ivBuilder.append("0");
		}
		iv = ivBuilder.toString();
		if(iv.length()>16){
			//超出16位截取
			iv = iv.substring(0,16);
		}
		this.iv = iv;
	}

	public void setSecretKey(String secretKey) {
		StringBuilder secretKeyBuilder = new StringBuilder(secretKey);
		while (secretKeyBuilder.length()<16){
			//不足16位补足
			secretKeyBuilder.append("0");
		}
		secretKey = secretKeyBuilder.toString();
		if(secretKey.length()>16){
			//超出16位截取
			secretKey = secretKey.substring(0,16);
		}
		this.secretKey = secretKey;
	}
}
