package cn.benma666.sjzt.rabbit;

import cn.benma666.sjzt.BasicFile;
import cn.benma666.sjzt.BasicSjzt;
import com.rabbitmq.client.GetResponse;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class RabbitMQFile extends BasicFile {
    /**
     * 名称
     */
    private String name;
    /**
     * 消费返回
     */
    private GetResponse response;

    public RabbitMQFile(String parent, BasicSjzt sjzt) {
        super(parent, sjzt);
    }

    public RabbitMQFile(String parent, BasicSjzt sjzt, String name) {
        super(parent, sjzt);
        this.name = name;
    }

    public RabbitMQFile(String parent, BasicSjzt sjzt, String name, GetResponse response) {
        super(parent, sjzt);
        this.name = name;
        this.response = response;
    }



    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public long lastModified() {
        return 0;
    }
}
