package cn.benma666.sjzt.ftp;

import cn.benma666.exception.MyException;
import cn.benma666.myutils.FileUtil;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.net.ftp.FTPClient;

import java.io.IOException;
import java.io.InputStream;

@Setter
@Getter
public class FtpInputStream extends InputStream{
    private InputStream is;
    private Ftp ftp;
    private FTPClient ftpClient;
    private boolean closed = false;

    public FtpInputStream(InputStream is, Ftp ftp,FTPClient ftpClient) {
        this.is = is;
        this.ftp = ftp;
        this.ftpClient = ftpClient;
    }

    @Override
    public int read() throws IOException {
        if(isClosed()){
            throw new MyException("该输入流已关闭");
        }
        return is.read();
    }

    @Override
    public void close() throws IOException {
        if(isClosed()){
            return;
        }
        super.close();
        FileUtil.closeStream(is);
        //退回持有的客户端
        ftp.returnClient(ftpClient);
        setClosed(true);
    }
}
