package cn.benma666.sjzt;

import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.exception.MyException;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * FTP客户端的对象工厂
 */
@Getter
@Setter
public class SjztPooledObjectFactory extends BasePooledObjectFactory<Object> {
    private static final Logger slog = LoggerFactory.getLogger(SjztPooledObjectFactory.class);
    /**
     * 数据载体
     */
    private final SysSjglSjzt sjzt;

    public SjztPooledObjectFactory(SysSjglSjzt sjzt) {
        this.sjzt = sjzt;
    }

    @Override
    public Object create() throws Exception {
        slog.trace("物理创建ftp客户端：{}",sjzt.getMc());
        try {
            return BasicSjzt.createSjztClient(sjzt);
        } catch (Exception e) {
            throw new MyException("物理创建ftp客户端失败："+sjzt.getMc(),e);
        }
    }

    @Override
    public boolean validateObject(PooledObject<Object> p) {
        try {
            return BasicSjzt.validateSjztClient(sjzt,p.getObject());
        } catch (Exception e) {
            slog.debug("客户端验证无效：{}",sjzt.getMc(),e);
            return false;
        }
    }

    @Override
    public PooledObject<Object> wrap(Object o) {
        return new DefaultPooledObject<>(o);
    }

    @Override
    public void destroyObject(PooledObject<Object> p) throws Exception {
        slog.trace("物理释放ftp客户端");//,new MyException("查看释放异常的堆栈路径")
        try {
            BasicSjzt.destroySjztClient(sjzt,p.getObject());
        } catch (Exception e) {
            slog.debug("客户端释放异常：{}",sjzt.getMc(),e);
        }
    }
}
