package cn.benma666.sjzt;

import cn.benma666.dict.Ljpd;
import cn.benma666.domain.SysQxYhxx;
import cn.benma666.exception.MyException;
import cn.benma666.myutils.ClassUtil;
import cn.benma666.myutils.DateUtil;
import cn.benma666.myutils.StringUtil;
import lombok.Getter;
import lombok.Setter;
import org.beetl.sql.annotation.entity.LogicDelete;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.query.LambdaQuery;
import org.jetbrains.annotations.Nullable;

import java.lang.reflect.Field;
import java.net.HttpURLConnection;

/**
 * 自动处理有效性、更新时间、创建人等。
 * @param <T> 被操作类
 */
@Setter
@Getter
public class MyLambdaQuery<T> extends LambdaQuery<T> {
    /**
     * 被操作类
     */
    private final Class<?> clazz;
    /**
     * 操作人
     */
    private SysQxYhxx user;

    public MyLambdaQuery(SQLManager sqlManager, Class clazz) {
        super(sqlManager, clazz);
        this.clazz = clazz;
    }

    @Override
    public int insertSelective(T t) {
        insertYcl(t);
        int num = super.insertSelective(t);
        if(num==0){
            throw new MyException("新增0条记录，异常", HttpURLConnection.HTTP_INTERNAL_ERROR,t);
        }else {
            return num;
        }
    }

    @Override
    public int insert(T t) {
        insertYcl(t);
        int num = super.insert(t);
        if(num==0){
            throw new MyException("新增0条记录，异常",HttpURLConnection.HTTP_INTERNAL_ERROR,t);
        }else {
            return num;
        }
    }

    /**
     * 更新数为0时会抛出异常
     */
    @Override
    public int update(Object t) {
        updateYcl(t);
        int num = super.update(t);
        if(num==0){
            throw new MyException("更新0条记录，异常",HttpURLConnection.HTTP_INTERNAL_ERROR,t);
        }else {
            return num;
        }
    }

    /**
     * 更新数为0时会抛出异常
     */
    @Override
    public int updateSelective(Object t) {
        int num = updateSelectiveGeneral(t);
        if(num==0){
            throw new MyException("更新0条记录，异常",HttpURLConnection.HTTP_INTERNAL_ERROR,t);
        }else {
            return num;
        }
    }
    /**
     * 常规更新
     */
    public int updateSelectiveGeneral(Object t) {
        updateYcl(t);
        return super.updateSelective(t);
    }

    /**
     * 增加创建人信息
     * @param t 对象实例
     */
    private void insertYcl(T t) {
        SjsjEntity se = clazz.getAnnotation(SjsjEntity.class);
        if(se != null){
            //数据世界实体
            if(StringUtil.isBlank(ClassUtil.getVal(SjsjField.gxsj.name(), null,t))){
                ClassUtil.setVal(SjsjField.gxsj.name(), DateUtil.getGabDate(),t);
            }
            if(StringUtil.isBlank(ClassUtil.getVal(SjsjField.cjsj.name(), null,t))){
                ClassUtil.setVal(SjsjField.cjsj.name(), DateUtil.getGabDate(),t);
            }
            if(StringUtil.isBlank(ClassUtil.getVal(SjsjField.id.name(), null,t))){
                ClassUtil.setVal(SjsjField.id.name(), StringUtil.getUUIDUpperStr(),t);
            }
            if(user!=null){
                ClassUtil.setVal(SjsjField.cjrxm.name(), user.getYhxm(),t);
                ClassUtil.setVal(SjsjField.cjrdm.name(), user.getId(),t);
                ClassUtil.setVal(SjsjField.cjrdwmc.name(), user.getJgxx().getJgmc(),t);
                ClassUtil.setVal(SjsjField.cjrdwdm.name(), user.getJgxx().getId(),t);
            }
            return;
        }
        for (Field f:clazz.getFields()){
            SjsjField ywlb = getSjsjField(f);
            if (ywlb == null) continue;
            switch (ywlb){
                case cjsj:
                case gxsj:
                    if(StringUtil.isBlank(ClassUtil.getVal(ywlb.name(), null,t))){
                        ClassUtil.setVal(f.getName(), DateUtil.getGabDate(),t);
                    }
                    break;
                case cjrdm:
                    ClassUtil.setVal(f.getName(), StringUtil.requireNonNull(user,"用户信息为空").getId(),t);
                    break;
                case cjrxm:
                    ClassUtil.setVal(f.getName(), StringUtil.requireNonNull(user,"用户信息为空").getYhxm(),t);
                    break;
                case cjrdwdm:
                    ClassUtil.setVal(f.getName(), StringUtil.requireNonNull(user,"用户信息为空").getJgxx().getId(),t);
                    break;
                case cjrdwmc:
                    ClassUtil.setVal(f.getName(), StringUtil.requireNonNull(user,"用户信息为空").getJgxx().getJgmc(),t);
                    break;
            }
        }
    }

    /**
     * 设置更新时间
     * @param t 对象实例
     */
    private void updateYcl(Object t) {
        SjsjEntity se = clazz.getAnnotation(SjsjEntity.class);
        boolean isNotWhere = super.getSql().length()==0;
        String gxsj = null;
        String id = null;
        if(se != null){
            //数据世界实体
            gxsj = SjsjField.gxsj.name();
            id = SjsjField.id.name();
        }else {
            for (Field f:clazz.getFields()){
                SjsjField ywlb = getSjsjField(f);
                if (ywlb == null) continue;
                if (ywlb== SjsjField.gxsj){
                    gxsj = f.getName();
                }
                if (ywlb== SjsjField.id){
                    id = f.getName();
                }
            }
        }
        if(gxsj!=null&&StringUtil.isBlank(ClassUtil.getVal(gxsj,null,t))){
            //有更新时间字段，且该字段值为空
            ClassUtil.setVal(gxsj, DateUtil.getGabDate(),t);
        }
        if(isNotWhere&&id!=null){
            //更新没有设置条件，自动设置主键作为条件
            andEq(id,StringUtil.requireNonNull(ClassUtil.getVal(
                    id,null,t),"更新没有设置条件"));
        }
        //底层是直接使用的sql变量，没有调用
        getSql();
    }

    /**
     * 定制sql过滤，自动增加有效性过滤
     * @return sql过滤条件
     */
    @Override
    public StringBuilder getSql() {
        if(sql!=null){
            return super.getSql();
        }
        //确保下面代码只进入一次
        sql = super.getSql();
        SjsjEntity se = clazz.getAnnotation(SjsjEntity.class);
        if(se != null){
            //表示是数据世界的实体
            andEq(SjsjField.yxx.name(), Ljpd.TURE.getCode());
        }else {
            LogicDelete lda;
            for (Field f:clazz.getFields()){
                lda = f.getAnnotation(LogicDelete.class);
                if(lda!=null){
                    //找到逻辑删除注解
                    andEq(f.getName(), lda.value());
                    break;
                }
            }
        }
        return super.getSql();
    }

    @Nullable
    private SjsjField getSjsjField(Field f) {
        SjsjEntity se;
        se = f.getAnnotation(SjsjEntity.class);
        if(se==null){
            return null;
        }
        SjsjField ywlb = se.value();
        if(se.value()== SjsjField.mrz){
            try {
                ywlb = SjsjField.valueOf(f.getName().toUpperCase());
            }catch (Exception e){
                throw new MyException(f.getName()+"字段没有正确的注解业务类别");
            }
        }
        return ywlb;
    }
}
