package cn.benma666.myutils;

import com.alibaba.fastjson.JSONObject;

import java.io.InputStream;

/**
 * http请求接口，采用采用如okhttp、httpclient等实现
 */
public interface HttpInterface {

    /**
     * 请求 <br/>
     * @param url 连接
     * @param param 参数,请求参数应该是 name1=value1&name2=value2 的形式，或json串，需要自行设置请求头信息。
     * @param qqbm 请求编码
     * @param cssc 超时时长
     * @param rp 请求属性，不能为空，直接调用本方法时，采用new一个json对象
     * @param repHeards 响应头信息,需要提前new好对象
     * @return 输入流，注意读取后进行关闭
     */
    InputStream inputStream(String url, Object param, String qqbm, int cssc,
                            JSONObject rp, JSONObject repHeards);
}
