package cn.benma666.myutils;

import cn.benma666.exception.MyException;
import cn.benma666.iframe.BasicObject;
import cn.benma666.vo.WjscVo;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import okhttp3.*;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 基于okhttp实现
 */
public class HttpByOk extends BasicObject implements HttpInterface{
    private static final HttpInterface hi = new HttpByOk();

    public static HttpInterface getInstance() {
        return hi;
    }
    private HttpByOk(){

    }
    @Override
    public InputStream inputStream(String url, Object param, String qqbm, int cssc, JSONObject rp, JSONObject repHeards) {
        try {
            OkHttpClient.Builder build = new OkHttpClient().newBuilder()
                    .connectTimeout(cssc, TimeUnit.MILLISECONDS)
                    .readTimeout(cssc, TimeUnit.MILLISECONDS)
                    .writeTimeout(cssc, TimeUnit.MILLISECONDS);
            if(url.startsWith("https")&&(isBlank(rp.getString("my-hlzs")) || TypeUtils.castToBoolean(rp.getString("my-hlzs")))){
                //添加https场景忽略证书
                build = build.sslSocketFactory(HttpUtil.trustAllHttpsCertificates().getSocketFactory())//配置
                        .hostnameVerifier(HttpUtil.getHostnameVerifier());//忽略验证证书
            }
            OkHttpClient okHttpClient = build.build();
            Request.Builder reqBuild = new Request.Builder().url(url);
            // 设置通用的请求属性
            String ct = "application/x-www-form-urlencoded;charset="+qqbm;
            reqBuild.header("Accept", "*/*").header("Connection", "Keep-Alive")
                    .header("User-Agent",
                            "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)")
                    .header("Accept-Charset", qqbm)
                    .header(HttpUtil.CONTENT_TYPE, ct)
                    .header("Accept-Language", Locale.getDefault().toString());
            for(Map.Entry<String, Object> e:rp.entrySet()){
                if(HttpUtil.CONTENT_TYPE.equals(e.getKey())){
                    ct = e.getValue().toString();
                }
                reqBuild.header(e.getKey(), e.getValue().toString());
            }
            String method = HttpPost.METHOD_NAME;
            if(StringUtil.isNotBlank(rp.getString("RequestMethod"))){
                method = rp.getString("RequestMethod");
            }
            RequestBody requestBody = null;
            if(ct.contains(ContentType.MULTIPART_FORM_DATA.getMimeType())){
                if(isBlank(param)||!(param instanceof JSONObject)){
                    throw new MyException("上传文件时参数必须是JSON对象");
                }
                JSONObject p = (JSONObject) param;
                //文件上传
                MultipartBody.Builder mb = new MultipartBody.Builder().setType(MultipartBody.FORM);
                for (Map.Entry e:p.entrySet()){
                    if(e.getValue() instanceof WjscVo){
                        WjscVo wjsc = (WjscVo) e.getValue();
                        mb.addFormDataPart(e.getKey().toString(),wjsc.getFileName(),wjsc.getRequestBody());
                    }else {
                        mb.addFormDataPart(e.getKey().toString(),e.getValue().toString());
                    }
                }
                requestBody = mb.build();
            }else if(!isBlank(param)){
                requestBody = RequestBody.create(param.toString(),MediaType.parse(ct));
            }
            log.trace("请求属性{}", rp);
            Request request=reqBuild.method(method,requestBody).build();
            Response response = okHttpClient.newCall(request).execute();

            //获返回取头部信息
            for(String key:response.headers().names()){
                repHeards.put(key, response.headers(key));
            }
            log.trace("返回头信息{}",repHeards.toString());
            if(response.code()== HttpURLConnection.HTTP_MOVED_TEMP
                    ||response.code()==HttpURLConnection.HTTP_MOVED_PERM){
                //重定向
                return inputStream(response.header("Location"),param,qqbm,cssc,rp,repHeards);
            }
            //得到输入流
            return response.body().byteStream();
        } catch (Exception e) {
            throw new MyException("请求失败", e, url+"->"+param+rp);
        }
    }
}
