/**
* Project Name:myutils
* Date:2019年10月13日
* Copyright (c) 2019, jingma All Rights Reserved.
*/

package cn.benma666.myutils;

import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.TriggerBuilder;

import java.text.ParseException;
import java.util.Date;

/**
* cron表达式工具类 <br/>
* date: 2019年10月13日 <br/>
* @author jingma
* @version
*/
public class CronUtil {

    /**
    * 上次执行时间 <br/>
    * @author jingma
    * @param cron
    * @return
    */
    public static long getLastTriggerTime(String cron){
        if(!CronExpression.isValidExpression(cron)){
            return 0;
        }
        CronTrigger trigger = TriggerBuilder.newTrigger().withIdentity("Caclulate Date")
                .withSchedule(CronScheduleBuilder.cronSchedule(cron)).build();
        Date time0 = trigger.getStartTime();
        Date time1 = trigger.getFireTimeAfter(time0);
        Date time2 = trigger.getFireTimeAfter(time1);
        Date time3 = trigger.getFireTimeAfter(time2);
        long l = time1.getTime() -(time3.getTime() -time2.getTime());
//      Date date = new Date(l);
//      SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return l;
    }
    /**
    * 获取下次执行时间（getFireTimeAfter，也可以下下次...） <br/>
    * @author jingma
    * @param cron
    * @return
    */
    public static long getNextTriggerTime(String cron){
        if(!CronExpression.isValidExpression(cron)){
            return 0;
        }
        try {
            CronExpression cronExpression = new CronExpression(cron);
            return cronExpression.getNextValidTimeAfter(new Date()).getTime();
        } catch (ParseException e) {
            return 0;
        }
//        CronTrigger trigger = TriggerBuilder.newTrigger().withIdentity("Caclulate Date")
//                .withSchedule(CronScheduleBuilder.cronSchedule(cron)).build();
//        Date time0 = trigger.getStartTime();
//        Date time1 = trigger.getFireTimeAfter(time0);
//        return time1.getTime();
    }
}
