package cn.benma666.main;

import cn.benma666.dict.Jmfs;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.BasicObject;
import cn.benma666.iframe.MyParams;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.StringUtil;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.JSONObject;

import java.io.FileInputStream;

/**
 * 密码加解密
 */
public class Mmjjm extends BasicObject {
    public static void main(String[] args) {
        if (args.length != 1) {
            slog.error("请输入参数文件路径");
            return;
        }
        try {
            //加载配置
            MyParams myParams = MyParams.parseObject(Utils.read(new FileInputStream(args[0])));
            System.out.println(jjm(myParams));
        }catch (Exception e){
            slog.error("加解密执行失败："+args[0],e);
        }
    }

    /**
     * 加解密
     */
    public static Result jjm(MyParams myParams) throws MyException {
        JSONObject yobj = myParams.yobj();
        StringBuilder jg = new StringBuilder();
        int i=0;
        switch (yobj.getString("clfs")){
            case "1":
                for (String val:yobj.getString("dcl").replace("\r","").split("\n")){
                    i++;
                    jg.append(StringUtil.encodeing(val, Jmfs.valueOf(yobj.getString("jmfs")),yobj.getString("mm1"),yobj.getString("mm2"))).append("\n");
                }
                break;
            case "2":
                for (String val:yobj.getString("dcl").replace("\r","").split("\n")){
                    i++;
                    jg.append(StringUtil.decodeing(val,Jmfs.valueOf(yobj.getString("jmfs")),yobj.getString("mm1"),yobj.getString("mm2"))).append("\n");
                }
                break;
            case "3":
                for (String val:yobj.getString("dcl").replace("\r","").split("\n")){
                    i++;
                    jg.append(StringUtil.generateKeyPair(val,yobj.getString("jmfs"))).append("\n");
                }
                break;
            default:
                throw new MyException("不支持的处理方式");
        }
        JSONObject obj = new JSONObject();
        obj.put("cljg",jg.toString().replace("\n\n","\n"));
        return success("成功处理："+i,obj);
    }
}
