/**
* Project Name:myutils
* Date:2017年8月28日
* Copyright (c) 2017, jingma All Rights Reserved.
*/

package cn.benma666.json;

import cn.benma666.domain.BasicBean;
import cn.benma666.exception.MyException;
import cn.benma666.myutils.ClassUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;


/**
 * json相关 <br/>
 * date: 2017年8月28日 <br/>
 * @author jingma
 * @version
 */
public class JsonUtil {
    private final static ParserConfig defaultRedisConfig = new ParserConfig();
    static { defaultRedisConfig.setAutoTypeSupport(true);}

    /**
     * 复制对象属性
     * @param mb 目标对象
     * @param ly 来源对象
     * @param path jsonpath路径
     */
    public static void copy(Object mb,Object ly,String path){
        JSONPath.set(mb,path,JSONPath.eval(ly,path));
    }

    /**
     * @param o 待序列化对象
     * @return 序列化的字符串，含字段类型
     */
    public static String objToStr(Object o){
        return new String(JSON.toJSONBytes(o, SerializerFeature.WriteClassName), IOUtils.UTF8);
    }

    /**
     * @param str 待转换的字符串
     * @param t 目标类型
     * @param <T> 泛型
     * @return 解析结果
     */
    public static <T> T strToObj(String str,Class<T> t){
        return JSON.parseObject(str,t, defaultRedisConfig);
    }
    /**
     * @param o 待克隆对象
     * @return 深克隆对象，且保留对象类型
     */
    public static <T> T clone(T o){
        return (T) strToObj(objToStr(o),Object.class);
    }

    /**
    * 合并多个json对象到新的json对象 <br/>
    * @author jingma
    * @param newObj 合并的目标对象，该对象数据会被修改
    * @param jsonObjects 待合并的对象
    * @return 合并结果newObj
    */
    public static JSONObject mergeJSONObjects(JSONObject newObj,JSONObject... jsonObjects){
        if(newObj==null){
            newObj = new JSONObject(true);
        }
        for(JSONObject obj:jsonObjects){
            mergeJSONObject(newObj,obj);
        }
        return newObj;
    }

    public static JSONObject mergeJSONObject(JSONObject newObj, BasicBean obj) {
        mergeJSONObject(newObj,obj.toJSONObject());
        return newObj;
    }
    public static <T extends BasicBean> T mergeJSONObject(T newObj, Object obj) {
        JSONObject json ;
        if(obj instanceof JSONObject){
            json = (JSONObject) obj;
        }else if(obj instanceof BasicBean){
            json = ((BasicBean) obj).toJSONObject();
        }else {
            throw new MyException("不支持的类型："+obj.getClass());
        }
        for(Entry<String ,?> e:json.entrySet()){
            if(e.getValue()==null){
                continue;
            }
            Object val = ClassUtil.getVal(e.getKey(), null, newObj);
            if(val instanceof JSONObject){
                //该字段是JSON对象实现进行进一步合并
                if(e.getValue() instanceof JSONObject){
                    mergeJSONObject((JSONObject) val,(JSONObject)e.getValue());
                }else if(e.getValue() instanceof BasicBean){
                    mergeJSONObject((JSONObject) val,(BasicBean)e.getValue());
                }else {
                    throw new MyException("对象合并异常，模板是json对象，来源为："+e.getValue().getClass().getName());
                }
            }else if(val instanceof BasicBean){
                //该字段是JSON对象实现进行进一步合并
                if(e.getValue() instanceof JSONObject){
                    mergeJSONObject((BasicBean) val, e.getValue());
                }else if(e.getValue() instanceof BasicBean){
                    mergeJSONObject((BasicBean) val, e.getValue());
                }else {
                    throw new MyException("对象合并异常，模板是json对象，来源为："+e.getValue().getClass().getName());
                }
            }else {
                ClassUtil.setVal(e.getKey(),e.getValue(),newObj);
            }
        }
        return newObj;
    }
    /**
    * 合并第二个json对象到第一个json对象 <br/>
    * @author jingma
    * @param newObj 新对象
    * @param obj 要合并进来的对象
    */
    public static <T> JSONObject mergeJSONObject(JSONObject newObj, Map<String, T> obj) {
        if(obj==null){
            return newObj;
        }
        for(Entry<String, T> e:obj.entrySet()){
            if(">delete".equals(e.getValue())) {
                //配置了移除该key
                newObj.remove(e.getKey());
            }else if(newObj.get(e.getKey()) instanceof BasicBean){
                mergeJSONObject((BasicBean) newObj.get(e.getKey()),e.getValue());
            }else if(e.getValue() instanceof BasicBean){
                JSONObject nk = newObj.getJSONObject(e.getKey());
                if(nk==null){
                    newObj.put(e.getKey(), e.getValue());
                }else {
                    //迭代合并
                    mergeJSONObject(nk, (BasicBean)e.getValue());
                    //确保若合并的对象是bean时最终还是bean
                    newObj.put(e.getKey(),JSON.parseObject(JSON.toJSONString(nk,
                            SerializerFeature.DisableCircularReferenceDetect),newObj.get(e.getKey()).getClass()));
                }
            }else if(e.getValue() instanceof JSONObject){
                JSONObject nk = newObj.getJSONObject(e.getKey());
                if(nk==null){
                    newObj.put(e.getKey(), e.getValue());
                }else {
                    //迭代合并
                    mergeJSONObject(nk, (JSONObject)e.getValue());
                    if(newObj.get(e.getKey()) instanceof BasicBean){
                        //确保若合并的对象是bean时最终还是bean
                        newObj.put(e.getKey(),JSON.parseObject(JSON.toJSONString(nk,
                                SerializerFeature.DisableCircularReferenceDetect),newObj.get(e.getKey()).getClass()));
                    }else {
                        newObj.put(e.getKey(), nk);
                    }
                }
            }else if(e.getValue() instanceof List){
                List<Object> nk = newObj.getJSONArray(e.getKey());
                if(nk==null){
                    nk = new JSONArray();
                    newObj.put(e.getKey(), nk);
                }
                //采用追加方式合并
                nk.addAll((List<Object>)e.getValue());
                newObj.put(e.getKey(),nk);
            }else{
                newObj.put(e.getKey(), e.getValue());
            }
        }
        return newObj;
    }
}
