/**
* @Title: Result.java
* @Description: json结果
* @author WangMengzhong
* @date 2013-6-5
* @version V1.0
*/
package cn.benma666.iframe;

import cn.benma666.exception.MyException;
import cn.benma666.myutils.StringUtil;
import cn.hutool.log.LogFactory;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;

import java.io.Serializable;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;

/**
 * json结果
 */
public class Result extends JSONObject implements Serializable {
	private static final long serialVersionUID = 1L;
	/**
	 * 数据类型,默认json，还支持文件
	 */
	public static final String DATE_TYPE = "dateType";
	/**
	 * 是否成功
	 */
	public static final String STATUS = "status";
	/**
	 * 状态码<br/>
	 * 优先采用：https://www.runoob.com/http/http-status-codes.html<br/>
	 * 9999：不统一处理，拦截器自行处理返回<br/>
	 */
	public static final String CODE = "code";
	/**
	 * 消息
	 */
	public static final String MSG = "msg";
	/**
	 * 附加信息对象
	 */
	public static final String DATA = "data";
	/**
	 * 请求编号
	 */
	public static final String QQID = "qqid";
	public Result(){
	}

	public Result(boolean status) {
		this(status,"");
	}

	public Result(boolean status, String msg) {
		this(status,msg,null);
	}

	public Result(boolean status, String msg, Object data) {
		put(DATE_TYPE, "application/json");
		put(STATUS,status);
		put(CODE,status? HttpURLConnection.HTTP_OK :HttpURLConnection.HTTP_BAD_REQUEST);
		put(MSG,msg);
		put(DATA,data);
	}

	public static  Result success(String msg){
		return new Result(true,msg);
	}
	public static  Result success(String msg,Object data){
		return new Result(true,msg,data);
	}
	public static  Result failed(String msg){
		return new Result(false,msg);
	}
	public static  Result failed(String msg,Object data){
		return new Result(false,msg,data);
	}

	public static  Result parse(Map<String,Object> map){
		Result r = new Result(TypeUtils.castToBoolean(map.get(STATUS)));
		r.putAll(map);
		return r;
	}
	public static  Result parse(String str){
		return parse(str,Feature.OrderedField);
	}
	public static  Result parse(String str,Feature... features){
		return parse(parseObject(str, features));
	}
	/**
	 * 追加消息 <br/>
	 * @author jingma
	 * @param msg 要追加的消息
	 */
	public void addMsg(String msg){
		if(StringUtil.isBlank(msg)){
			return;
		}
		String msg1 = getString(MSG);
		if(StringUtil.isNotBlank(msg1)){
			msg1+="，";
		}
		msg1+=msg;
		put("msg",msg1);
	}
    /**
     * @return status
     */
    public boolean isStatus() {
        return getBoolean(STATUS);
    }
    /**
     * @param status the status to set
     */
    public void setStatus(boolean status) {
        put(STATUS,status) ;
    }
    /**
	 * @return the msg
	 */
	public String getMsg() {
		return getString(MSG);
	}
	/**
	 * @param msg the msg to set
	 */
	public void setMsg(String msg) {
		put(MSG,msg) ;
	}
	public int getCode() {
		return getIntValue(CODE);
	}
	public void setCode(int code) {
		put(CODE,code);
	}
	public String getQqid() {
		return getString(QQID);
	}
	public void setQqid(String qqid) {
		put(QQID,qqid);
	}
	/**
     * @return data
     */
    public Object getData() {
        return get(DATA);
    }

	/**
	 * 将data转换为指定类型后获取
	 * @param t 要转为的类型
	 */
	public <R> R getData(Class<R> t){
		Object o = get(DATA);
		return o==null?null:t.cast(o);
	}

	/**
	 * 获取分页的列表
	 */
	public <R> List<R> getPageList(Class<R> t){
		return getData(PageInfo.class).getList(t);
	}
    /**
     * @param data the data to set
     */
    public void setData(Object data) {
        put(DATA,data);
    }

	public String getDateType() {
		return getString(DATE_TYPE);
	}

	public void setDateType(String dateType) {
		put(DATE_TYPE,dateType);
	}

	@Override
	public String toString() {
		if(getData() instanceof MyParams){
			//复制一个对象出来，避免影响参数对象本身
			JSONObject t = ((JSONObject)getData()).clone();
			put(DATA,t);
		}
		try {
			//SerializerFeature.WriteMapNullValue,
			return super.toString(SerializerFeature.DisableCircularReferenceDetect);
		}catch (Throwable t){
			LogFactory.get().error("该Result转为字符串失败",t);
			return failed("该Result转为字符串失败："+t.getMessage()).toString();
		}
	}

	/**
	 * @return 基于该结果的异常
	 */
	public MyException newMyException(){
		MyException e = new MyException(getMsg(), getData());
		e.setCode(getCode());
		return e;
	}
}
