package cn.benma666.iframe;

import cn.benma666.domain.BasicBean;
import com.alibaba.fastjson.JSON;
import lombok.*;
import org.beetl.sql.core.page.PageRequest;
import org.beetl.sql.core.page.PageResult;

import java.io.Serializable;
import java.util.List;

/**
 * 分页信息
 */
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PageInfo<T> extends BasicBean implements Serializable,PageRequest<T>,PageResult<T>{

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 查询统计总量
	 */
	private boolean totalRequired = true;
    /**
     * 是否查询列表数据，当只获取数据总量时设置为false。
     */
    private boolean listRequired = true;
	/**
	 * 页码
	 */
	private long pageNumber=1;
	/**
	 * 页大小
	 */
	private int pageSize=10;
	/**
	 * 数据总量
	 */
	private long totalRow = -1;
	/**
	 * 页数
	 */
	private long totalPage;
	/**
	 * 数据
	 */
	private List<T> list;
	/**
	 * 排序
	 */
	private String orderBy;

	public PageInfo(List<T> list, int pageSize, int totalRow, int pageNumber) {
		this.list = list;
		this.pageSize = pageSize;
		this.pageNumber = pageNumber;
		setTotalRow(totalRow);
	}

	/**
     * @return totalRequired
     */
    public boolean isTotalRequired() {
        return totalRequired;
    }
    /**
     * @param totalRequired the totalRequired to set
     */
    public void setTotalRequired(boolean totalRequired) {
        this.totalRequired = totalRequired;
    }
    /**
     * @return listRequired
     */
    public boolean isListRequired() {
        return listRequired;
    }
    /**
     * @param listRequired the listRequired to set
     */
    public void setListRequired(boolean listRequired) {
        this.listRequired = listRequired;
    }
    public long getPageNumber() {
		return pageNumber;
	}
	public void setPageNumber(long pageNumber) {
		this.pageNumber = pageNumber;
	}
	public int getPageSize() {
		return pageSize;
	}
	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}
	public List<T> getList() {
		return list;
	}

	/**
	 * 获取指定实体类的列表
	 * @param t 实体类类型
	 */
	public <R> List<R> getList(Class<R> t){
		return JSON.parseArray(list.toString(),t);
	}
	public void setList(List<T> list) {
		this.list = list;
	}
	public long getTotalRow() {
		return totalRow;
	}
	public void setTotalRow(long totalRow) {
		if(pageSize>0&&totalRow>0){
			setTotalPage(totalRow/pageSize+(totalRow%pageSize>0?1:0));
            if(getPageNumber()>getTotalPage()){
            	setPageNumber(getTotalPage());
            }
		}
		this.totalRow = totalRow;
	}
	public long getTotalPage() {
		return totalPage;
	}
	public void setTotalPage(long totalPage) {
		this.totalPage = totalPage;
	}

	@Override
	public String toString() {
		return JSON.toJSONString(this);
	}

    /**
    *
    * @see org.beetl.sql.core.page.PageRequest#getOrderBy()
    */
    @Override
    public String getOrderBy() {
		return orderBy;
    }

	public void setOrderBy(String orderBy) {
		this.orderBy = orderBy;
	}
	//////////////////////////////////////////////
    /**
    *
    * @see org.beetl.sql.core.page.PageRequest#of(java.util.List)
    */
    @Override
    public PageResult<T> of(List<T> result) {
        this.setList(result);
        return this;
    }
    /**
    *
    * @see org.beetl.sql.core.page.PageRequest#of(java.util.List, java.lang.Long)
    */
    @Override
    public PageResult<T> of(List<T> result, Long total) {
        this.setList(result);
        this.setTotalRow(total);
        return this;
    }

}
