package cn.benma666.iframe;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.status.ErrorStatus;
import cn.benma666.constants.UtilConst;
import cn.benma666.exception.MyException;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.Db;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

/**
 * 我的logback日志记录器，主要用于将错误日志记录到数据库中
 * @param <E>
 */
public class MyLogBackAppender<E extends ILoggingEvent> extends UnsynchronizedAppenderBase<E> {
    /**
     * 线程池
     */
    private static InterfaceThreadPool tp;
    /**
     * 日志编码器
     */
    protected Encoder<E> encoder;
    /**
     * 消息编码器
     */
    protected Encoder<E> msgEncoder;
    /**
     * 数据库名称
     */
    private String dbName = UtilConst.DEFAULT;
    /**
     * 日志插入sql
     */
    private String insertSql;

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setInsertSql(String insertSql) {
        this.insertSql = insertSql;
    }
    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    public void start() {
        int errors = 0;
        if (this.encoder == null) {
            this.addStatus(new ErrorStatus("No encoder set for the appender named \"" + this.name + "\".", this));
            ++errors;
        }

        if (errors == 0) {
            super.start();
        }

    }

    public void setLayout(Layout<E> layout) {
        LayoutWrappingEncoder<E> lwe = new LayoutWrappingEncoder();
        lwe.setLayout(layout);
        lwe.setContext(this.context);
        this.encoder = lwe;
    }

    public void setMsgLayout(Layout<E> layout) {
        LayoutWrappingEncoder<E> lwe = new LayoutWrappingEncoder();
        lwe.setLayout(layout);
        lwe.setContext(this.context);
        this.msgEncoder = lwe;
    }

    @Override
    protected void append(E e) {
        if(tp!=null){
            //进行线程隔离，避免业务层面开启的事务导致后台日志表被锁
            tp.run(()->clrz(e));
        }else {
            clrz(e);
        }
    }

    /**
     * 处理日志
     * @param e 日志对象
     */
    public void clrz(E e){
        try {
            String msg = new String(msgEncoder.encode(e));
            for(String hl:DictManager.zdMap("SYS_LOG_HTRZ_HL").keySet()){
                if(msg.contains(hl)){
                    //采用正则匹配，满足忽略条件的就进行忽略，不计入后台日志表
                    return;
                }
            }
            String[] msgs = new String(encoder.encode(e)).split("#!#");
            JSONObject p = JSON.parseObject(msgs[0]);
            p.put("message",StringUtil.substrByByte(msg,4000));
            p.put("id", StringUtil.getUUIDUpperStr());
            p.put("ssxm",Conf.getAppdm());
            Db.use(dbName).update(insertSql,p);
        }catch (MyException ex){
            //可控错误
        }catch (Exception ex){
            System.err.println(ex.getMessage()+":"+new String(encoder.encode(e)));
            ex.printStackTrace();
        }
    }

    public static InterfaceThreadPool getTp() {
        return tp;
    }

    public static void setTp(InterfaceThreadPool tp) {
        MyLogBackAppender.tp = tp;
    }
}
