
package cn.benma666.iframe;

import cn.benma666.config.Benma666;
import cn.benma666.dict.Zdlb;
import cn.benma666.exception.MyException;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.Db;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.Properties;

/**
* 配置管理 <br/>
* date: 2018年12月7日 <br/>
* @author jingma
* @version 0.2
*/
public class Conf extends BasicObject{
	/**
    * 配置类别列表
    */
    public static final String CONFIG_LIST = "benma666.config-list";
    /**
     * 空配置
     */
    public final static String[] emptyConfigArr = new String[]{};
    /**
    * 字典配置类别列表
    */
    private static String[] configArr;
    /**
	* 外部出入的配置，为基础配置，优先级最高
	*/
	private static ConfAbstract<?> config;
    /**
     * benma666的配置对象化结果
     */
    private static Benma666 utilConfig;

    /**
     * 默认初始化配置
     */
    public static void defaultInit(){
        utilConfig = new Benma666();
        utilConfig.setDebug(true);
        utilConfig.setConfigList(Zdlb.SYS_COMMON_APPCONFIG.name());
        defaultInit(utilConfig);
    }

    /**
     * 默认初始化配置
     * @param benma666 默认配置
     */
    public static void defaultInit(Benma666 benma666){
        if(benma666==null){
            throw new MyException("默认配置不能为空");
        }
        utilConfig = benma666;
        setConfig(new Benma666Conf(benma666));
    }

    /**
     * 获取配置信息
     * @param key 配置键
     * @param defVal 默认值
     * @return 值
     */
    public static String getVal(String key,String defVal){
        return valByDef(getVal(key),defVal);
    }
	/**
	 * 获取配置信息
	 * @param key 配置键
	 * @return 值
	 */
	public static String getVal(String key){
	    String value = getValByConfig(key);
	    if (value==null&& Db.isDefaultInit()) {
	        value = getValByDict(key);
        }
		return value;
	}
    /**
    * 从字典中获取配置 <br/>
    * @author jingma
    * @param key 键
    * @return 值
    */
    public static String getValByDict(String key) {
        if(CONFIG_LIST.equals(key)){
            return null;
        }
        //使用字典配置，从后往前加载
        String value = null;
        for(int i=getConfigArr().length-1;i>-1;i--){
            String cc = configArr[i];
            value = DictManager.zdMcByDm(cc, key);
            if(!key.equals(value)){
                break;
            }
        }
        if(key.equals(value)){
            //从字典配置中没有找到该配置
            value = null;
        }
        return value;
    }
    public static String getValByConfig(String key){
        return getConfig().getVal(key);
    }
	/**
	* 获取json对象配置 <br/>
	* @author jingma
	* @param key 键
	* @return 转为json对象的值
	*/
	public static JSONObject getJSONObject(String key){
	    String val = getVal(key);
	    if(StringUtil.isNotBlank(val)){
	        return JSON.parseObject(val);
	    }else{
	        return new JSONObject();
	    }
	}
    /**
     * @return config
     */
    public static ConfAbstract<?> getConfig() {
        if(config==null){
            throw new MyException("系统外部配置未设置，不能使用配置读取");
        }
        return config;
    }
    /**
     * @param config the config to set
     */
    public static void setConfig(ConfAbstract<?> config) {
        Conf.config = config;
    }

    /**
     * @return 获取全部配置信息-从字典中获取的。
     */
    public static Properties getPropertiesByDict(){
        Properties p = new Properties();
        for(int i=getConfigArr().length-1;i>-1;i--){
            String cc = configArr[i];
            JSONObject map = DictManager.zdMap(cc);
            if(isBlank(map)){
                continue;
            }
            for(String key:map.keySet()){
                p.put(key,map.getJSONObject(key).getString("mc"));
            }
        }
        return p;
    }

    public static String[] getConfigArr() {
        if(configArr==null){
            String cf = config.getVal(CONFIG_LIST);
            if(StringUtil.isBlank(cf)){
                //暂时没有获取配置的字典类别列表，springcloud场景，加载顺序可能这个
                return emptyConfigArr;
            }else {
                configArr = cf.split(",");
            }
        }
        return configArr;
    }

    /**
     * @return 应用代码
     */
    public static String getAppdm(){
        return utilConfig.getAppDm();
    }

    public static Benma666 getUtilConfig() {
        return utilConfig;
    }

    public static void setUtilConfig(Benma666 utilConfig) {
        Conf.utilConfig = utilConfig;
    }
}
