/**
* Project Name:myutils
* Date:2019年4月17日
* Copyright (c) 2019, jingma All Rights Reserved.
*/

package cn.benma666.iframe;

import cn.benma666.exception.MyException;
import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

/**
 * 缓存工厂 <br/>
 * date: 2019年4月17日 <br/>
 * @author jingma
 * @version 0.2
 */
public class CacheFactory{
    /**
     * 缓存类型-内存
     */
    public static final String TYPE_MEMORY = "memory";
    /**
     * 缓存类型-redis
     */
    public static final String TYPE_REDIS = "redis";
    /**
     * 缓存MAP
     */
    private static Map<String, JSONObject> cacheMap = new HashMap<>();

    /**
     * 获取缓存对象 <br/>
     *
     * @param key 键
     * @param type 类型
     * @return 缓存对象
     * @author jingma
     */
    public static JSONObject use(String key, String type) {
        JSONObject c = cacheMap.get(key);
        if (c == null) {
            if (TYPE_REDIS.equals(type)) {
                throw new MyException("暂时不支持redis缓存机制");
            } else {
                c = new JSONObject();
            }
            cacheMap.put(key, c);
        }
        return c;
    }

    /**
     * 使用默认缓存方式 <br/>
     *
     * @param key 键
     * @return 缓存对象
     * @author jingma
     */
    public static JSONObject use(String key) {
        return use(key, "default");
    }

    /**
     * 清空全部缓存 <br/>
     * @author jingma
     */
    public static void clear() {
        for (Entry<String, JSONObject> e : cacheMap.entrySet()) {
            e.getValue().clear();
        }
    }

    /**
     * 清除指定缓存 <br/>
     *
     * @param key 键
     * @return 处理结果
     * @author jingma
     */
    public static int clear(String key) {
        JSONObject cache = cacheMap.get(key);
        if (cache != null) {
            int size = cache.size();
            cache.clear();
            return size;
        }
        return -1;
    }

    public static Map<String, JSONObject> getCacheMap() {
        return cacheMap;
    }

    public static void setCacheMap(Map<String, JSONObject> cacheMap) {
        CacheFactory.cacheMap = cacheMap;
    }
}
