/**
* Project Name:myutils
* Date:2021年9月14日
* Copyright (c) 2021, jingma All Rights Reserved.
*/

package cn.benma666.iframe;

import cn.benma666.config.Benma666;
import cn.benma666.sjzt.Db;
import cn.hutool.log.Log;
import com.alibaba.fastjson.JSONObject;

/**
 * JSON配置 <br/>
 * date: 2021年9月14日 <br/>
 * @author jingma
 * @version
 */
public class Benma666Conf extends ConfAbstract<JSONObject> {

    /**
    * Creates a new instance of JSONObjectConf.
    * @param config
    */
    public Benma666Conf(Benma666 config) {
        super(Db.buildKeyMap("benma666",config.toJSONObject()));
    }

    /**
    *
    * @see cn.benma666.iframe.ConfAbstract#getVal(java.lang.String)
    */
    @Override
    public String getVal(String key) {
        try {
            return config.getString("$."+key);
        }catch (Exception e){
            Log.get().trace(e);
            return null;
        }
    }
}
