/**
* Project Name:myutils
* Date:2019年4月22日
* Copyright (c) 2019, jingma All Rights Reserved.
*/

package cn.benma666.iframe;

import cn.benma666.constants.UtilConst;
import cn.benma666.domain.SysSjglBhsc;
import cn.benma666.exception.MyException;
import cn.benma666.myutils.DateUtil;
import cn.benma666.myutils.StringUtil;
import cn.benma666.myutils.TmplUtil;
import cn.benma666.sjzt.Db;
import com.alibaba.fastjson.JSONObject;
import lombok.Getter;
import lombok.Setter;

/**
 * 自增id <br/>
 * date: 2019年4月22日 <br/>
 * @author jingma
 * @version 0.2
 */
@Setter
@Getter
public class AutoId extends BasicObject{
    /**
     * 编号对象
     */
    private SysSjglBhsc bh = new SysSjglBhsc();
    /**
     * 获取最大变化的sql，初始化时使用
     */
    private String maxSql;
    /**
     * 自增缓存
     */
    private static JSONObject cache = CacheFactory.use(AutoId.class.getSimpleName());

    /**
    * 通过传入的sql获取初始值
    * @param maxSql 编号类别
    */
    private AutoId(String name,String maxSql) {
        this.maxSql = maxSql;
        cache.put(name,this);
    }

    /**
     * @param bh 编号对象
     */
    private AutoId(SysSjglBhsc bh) {
        this.bh = bh;
        cache.put(bh.getBhlb(),this);
    }

    public static AutoId use(String name,String maxSql){
        try {
            return use(name);
        }catch (MyException e){
            return new AutoId(name,maxSql);
        }
    }
    public static AutoId use(SysSjglBhsc bh){
        try {
            return use(bh.getBhlb());
        }catch (MyException e){
            return new AutoId(bh);
        }
    }
    /**
     * 获取缓存的自增对象
     * @param name 名称
     * @return 缓存的自增对象
     */
    public static AutoId use(String name){
        Object ai = cache.get(name);
        if(ai==null){
            throw new MyException("没有该自增对象："+name);
        }
        return (AutoId) ai;
    }
    public static AutoId useByBhlb(String bhlb){
        return use(new SysSjglBhsc(bhlb));
    }
    public static long next(AutoId ai){
        return ai.next();
    }
    public static String next(AutoId ai,int length){
        return ai.next(length);
    }
    public static String nextByMb(AutoId ai){
        return ai.nextByMb();
    }

    /**
     * @return 当前值
     */
    public int getDqz(){
        if(bh.getDqz()==0){
            if(maxSql!=null){
                String[] arr = Db.parseDictExp(maxSql, UtilConst.DEFAULT);
                assert arr != null;
                bh.setDqz(db(arr[0]).queryInt(arr[1]));
            }else if(bh.getBhlb()!=null){
                bh = db().lambdaQuery(SysSjglBhsc.class)
                        .andEq(SysSjglBhsc::getBhlb, bh.getBhlb()).singleSimple();
                if (bh == null) {
                    throw new MyException("编号类别不存在：" + bh);
                }
            }
        }
        return bh.getDqz();
    }
    /**
    * 下一个值 <br/>
    * @author jingma
    */
    public synchronized long next(){
        final int dqz = getDqz();
        bh.setDqz(dqz+bh.getDzl());
        if(StringUtil.isNotBlank(bh.getCzzq())&&!bh.getDqzq().equals(
                DateUtil.getDateTimeStr(DateUtil.DATE_FORMATTER8))){
            //重置周期，且跨天了
            switch (bh.getCzzq()){
                case "nian":
                    if(!bh.getDqzq().substring(0,4).equals(DateUtil.getDateTimeStr("YYYY"))){
                        bh.setDqz(bh.getCsz());
                    }
                    break;
                case "yue":
                    if(!bh.getDqzq().equals(DateUtil.getDateTimeStr("YYYYMM"))){
                        bh.setDqz(bh.getCsz());
                    }
                    break;
                case "ri":
                    bh.setDqz(bh.getCsz());
                    break;
                default:
                    throw new MyException("周期类型错误："+bh.getCzzq());
            }
            bh.setDqzq(DateUtil.getDateTimeStr(DateUtil.DATE_FORMATTER8));
        }
        if(bh.getDqz()>=bh.getZdz()){
            bh.setDqz(bh.getCsz());
        }
        if(bh.getBhlb()!=null){
            bh.setGxsj(DateUtil.getGabDate());
            //每次都要更新，避免异常停止后重复
            sqlManager().updateTemplateById(bh);
        }
        return bh.getDqz();
    }
    /**
    * 下一个值 <br/>
    * @author jingma
    * @param length 补全位数
    * @return 用0补全的字符串
    */
    public String next(int length){
        return String.format("%0"+length+"d", next());
    }

    /**
     * @return 基于模板的下一个值 <br/>
     */
    public String nextByMb(){
        //读取下个一编号
        next();
        if(StringUtil.isBlank(bh.getBhmb())){
            throw new MyException("编号模板不能为空");
        }
        //模板生成：XXBH-${du.getDateTimeStr('YYYY')}-${@String.format('%06d',bh.dqz)}
        return TmplUtil.buildStr(bh.getBhmb(),Db.buildKeyMap("bh",bh));
    }

}
