/**
* Project Name:myutils
* Date:2018年12月4日
* Copyright (c) 2018, jingma All Rights Reserved.
*/

package cn.benma666.exception;

import java.net.HttpURLConnection;

/**
 * 业务异常，正常情况下这种异常不需要人工干预 <br/>
 * @author jingma
 * @version 0.2
 */
public class BusinessException extends MyException{

    /**
    *
    */
    private static final long serialVersionUID = 1463806345429361813L;
    /**
     * Creates a new instance of ExcelReadException.
     */
    public BusinessException() {
    }

    /**
    * Creates a new instance of ExcelReadException.
    * @param message 异常消息
    */
    public BusinessException(String message) {
        this(message, HttpURLConnection.HTTP_BAD_REQUEST);
    }
    /**
    * Creates a new instance of QxException.
    * @param message 异常消息
    * @param code 异常代码
    */
    public BusinessException(String message, int code) {
        super(message);
        setCode(code);
    }

    /**
    * Creates a new instance of ExcelReadException.
    * @param message 异常消息
    * @param cause 原异常
    */
    public BusinessException(String message, Throwable cause) {
        super(message, cause,null,HttpURLConnection.HTTP_BAD_REQUEST,null);
    }
    public BusinessException(String message, Throwable cause,String nbxx) {
        super(message, cause,null,HttpURLConnection.HTTP_BAD_REQUEST,nbxx);
    }
}
