package cn.benma666.excel;


import cn.benma666.constants.UtilConst;
import cn.benma666.domain.SysSjglFile;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.Conf;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.HttpUtil;
import cn.benma666.myutils.PicUtils;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.Db;
import com.alibaba.druid.util.Utils;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ImageData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.client.methods.HttpGet;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/**
 * @Description 图片处理
 **/
@Slf4j
public class ImageConverter implements Converter<ImageConverterKey> {

    @Override
    public Class<?> supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public WriteCellData<?> convertToExcelData(ImageConverterKey value, ExcelContentProperty contentProperty,
                                               GlobalConfiguration globalConfiguration) throws IOException {
        List<ImageData> data = ListUtils.newArrayList();
        if(value.getIn()!=null){
            //输入流
            try {
                ImageData imageData = new ImageData();
                imageData.setImage(PicUtils.compressPicForScale(
                        Utils.readByteArray(value.getIn()),200));
                imageData.setTop(1);
                imageData.setRight(1);
                imageData.setBottom(1);
                imageData.setLeft(1);
                data.add(imageData);
            }finally {
                FileUtil.closeStream(value.getIn());
            }
        }else if(StringUtil.isNotBlank(value.getLj())){
            HttpUtil hu = HttpUtil.builder().addRp(HttpUtil.REQUEST_METHOD,
                    HttpGet.METHOD_NAME).build();
            int i=0;
            String[] urls = value.getLj().split(",");
            for (String url : urls) {
                InputStream inputStream = null;
                try {
                    if(url.startsWith("http")){
                        inputStream = hu.getInputStream(url);
                    }else if(url.length()==32&&!url.contains(".")){
                        //非完整连接，长度为32，则认为是文件id
                        SysSjglFile sysSjglFile = Db.use().lambdaQuery(SysSjglFile.class).andEq(SysSjglFile::getId, url).singleSimple();
                        if(sysSjglFile==null){
                            throw new MyException("文件没有找到："+url);
                        }
                        inputStream = sysSjglFile.getInputStream();
                    }else {
                        inputStream = hu.getInputStream(Conf.getUtilConfig().getService().getTydlzd() +url);
                    }
                    byte[] bytes = PicUtils.compressPicForScale(
                            Utils.readByteArray(inputStream),200);
                    ImageData imageData = new ImageData();
                    imageData.setImage(bytes);
                    //多张图片依次错位一点
                    imageData.setTop(10*i+1);
                    imageData.setBottom(10*(urls.length-i-1)+1);
                    imageData.setRight(10*(urls.length-i-1)+1);
                    imageData.setLeft(10*i+1);
                    data.add(imageData);
                    i++;
                } catch (Exception e) {
                    //图片异常展示的图片
                    log.error("图片获取异常：{}",url,e);
                } finally {
                    FileUtil.closeStream(inputStream);
                }
            }
        }else {
            return new WriteCellData<>("暂无图片");
        }
        WriteCellData cellData = new WriteCellData();
        cellData.setType(CellDataTypeEnum.EMPTY);
        cellData.setImageDataList(data);
        return cellData;
    }
}
