/**
* by jingma 2022-10-05
*/
package cn.benma666.domain;

import cn.benma666.iframe.AutoId;
import cn.benma666.iframe.InterfaceThreadPool;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.SjsjEntity;
import cn.benma666.vo.ZnjhTPConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

/**
 * 系统-数据管理-智能交换
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "sys_sjgl_znjh")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysSjglZnjh extends BasicBean{
	/**
	 * 备份载体@SYS_COMMON_SJZT;过滤只允许选择该网络空间的数据载体，不选择则不进行备份。
	 */
	@Column("BFZT")
	private String bfzt;
	/**
	 * 不规范文件正则;文件记录推送日志，推送日志状态为：忽略，文件不推送到底层网闸，备份到备份目录后删除
	 */
	@Column("BGFWJZZ")
	private String bgfwjzz;
	/**
	 * 创建人代码
	 */
	@Column("CJRDM")
	private String cjrdm;
	/**
	 * 创建人单位代码
	 */
	@Column("CJRDWDM")
	private String cjrdwdm;
	/**
	 * 创建人单位名称
	 */
	@Column("CJRDWMC")
	private String cjrdwmc;
	/**
	 * 创建人姓名
	 */
	@Column("CJRXM")
	private String cjrxm;
	/**
	 * 创建时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 输入目录
	 */
	@Column("SRML")
	private String srml;
	/**
	 * 输出目录
	 */
	@Column("SCML")
	private String scml;
	/**
	 * 备份目录
	 */
	@Column("BFML")
	private String bfml;
	/**
	 * 更新时间
	 */
	@Column("GXSJ")
	private String gxsj;
	/**
	 * 工作模式@SYS_SJGL_ZNJH_GZMS
	 */
	@Column("GZMS")
	private String gzms;
	/**
	 * 主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("ID")
	private String id;
	/**
	 * 交换节点@SYS_QX_APP;用于设置该任务在哪个交换节点上执行
	 */
	@Column("JHJD")
	private String jhjd;
	/**
	 * 监听间隔；格式nHnMnS
	 */
	@Column("JTJG")
	private String jtjg;
	/**
	 * 监听器类型@SYS_SJGL_ZNJH_JTQLX
	 */
	@Column("JTQLX")
	private String jtqlx;
	/**
	 * 监听器状态@SYS_SJGL_ZXZT
	 */
	@Column("JTQZT")
	private String jtqzt;
	/**
	 * 监听文件正则，排除多个字符串样例：^(?!.*(\.unimastmp|test21_).*$).*$
	 */
	@Column("JTWJZZ")
	private String jtwjzz;
	/**
	 * 扩展信息
	 */
	@Column("KZXX")
	private String kzxx;
	/**
	 * 排序
	 */
	@Column("PX")
	private BigDecimal px;
	/**
	 * 输出载体@SYS_COMMON_SJZT;过滤只允许选择该网络空间的数据载体
	 */
	@Column("SCZT")
	private String sczt;
	/**
	 * 输入载体@SYS_COMMON_SJZT;过滤只允许选择该网络空间的数据载体
	 */
	@Column("SRZT")
	private String srzt;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("YXX")
	private String yxx;
	/**
	 * 最大文件大小；单位kb|mb|gb
	 */
	@Column("DXXZ")
	private String dxxz;
	/**
	 * 交换名称
	 */
	@Column("JHMC")
	private String jhmc;
	/**
	 * 交换描述
	 */
	@Column("JHMS")
	private String jhms;
	/**
	 * 返回交换@SYS_SJGL_ZNJH;不选择则没有返回
	 */
	@Column("FHJH")
	private String fhjh;
	/**
	 * 记录日志@SYS_COMMON_LJPD
	 */
	@Column("JLRZ")
	private String jlrz = "1";
	/**
	 * 删除源文件@SYS_COMMON_LJPD
	 */
	@Column("SCYWJ")
	private String scywj = "1";
	/**
	 * 小文件等待；格式nHnMnS
	 */
	@Column("XWJDD")
	private String xwjdd = "0.1s";
	/**
	 * 大文件等待；格式nHnMnS
	 */
	@Column("DWJDD")
	private String dwjdd = "1s";
	/**
	 * 修改时间差小于;与当前时间相比,格式：PnYnMnDTnHnMnS
	 */
	@Column("XGSJCXY")
	private String xgsjcxy;
	/**
	 * 修改时间差大于;与当前时间相比,格式：PnYnMnDTnHnMnS
	 */
	@Column("XGSJCDY")
	private String xgsjcdy;
	/**
	 * 监听文件
	 */
	@Transient
	private Pattern jtwjPattern;
	/**
	 * 不规范文件
	 */
	@Transient
	private Pattern bgfwjPattern;
	/**
	 * 自增对象
	 */
	@Transient
	private AutoId autoId;
	/**
	 * 扩展信息对象
	 */
	@Transient
	private JSONObject kzxxObj = new JSONObject();
	/**
	 * 处理中的文件
	 */
	@Transient
	private Set<String> clzwj = Collections.synchronizedSet(new HashSet<>());
	/**
	 * 线程池
	 */
	@Transient
	protected InterfaceThreadPool tp;
	/**
	 * 遍历包含目录
	 */
	@Transient
	private boolean blbhml = false;
	/**
	 * 递归遍历
	 */
	@Transient
	private boolean dgbl = true;
	/**
	 * 智能交换线程池配置
	 */
	@Transient
	private ZnjhTPConfig tpc;

	public void setKzxx(String kzxx) {
		this.kzxx = StringUtil.valByDef(kzxx,"{}");
		this.kzxxObj = JSON.parseObject(this.kzxx);
		if(StringUtil.isNotBlank(kzxxObj.get("xccpz"))){
			setTpc(kzxxObj.getObject("xccpz",ZnjhTPConfig.class));
		}else {
			setTpc(new ZnjhTPConfig());
		}
	}
	public boolean isJlrz(){
		return TypeUtils.castToBoolean(getJlrz());
	}
	public boolean isScywj(){
		return TypeUtils.castToBoolean(getScywj());
	}

	public String getSrml() {
		return FileUtil.getFilePath(srml);
	}

	public void setJtwjzz(String jtwjzz) {
		this.jtwjzz = jtwjzz;
		if(StringUtil.isNotBlank(jtwjzz)){
			setJtwjPattern(Pattern.compile(jtwjzz));
		}
	}

	public void setBgfwjzz(String bgfwjzz) {
		this.bgfwjzz = bgfwjzz;
		if(StringUtil.isNotBlank(bgfwjzz)){
			setBgfwjPattern(Pattern.compile(bgfwjzz));
		}
	}

	public void setId(String id) {
		this.id = id;
		setAutoId(AutoId.use(id,"select max(wjbh) from sys_log_jhjl t where t.xgjh='"+id+"'"));
	}
}
