/**
* by jingma 2019-04-18
*/
package cn.benma666.domain;

import cn.benma666.sjzt.SjsjEntity;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.List;

/**
 * 系统-数据管理-统一字典
 */
@Table(name = "SYS_SJGL_TYZD")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysSjglTyzd extends BasicBean{

	/**
	 * 序列化
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 字典类别
	 */
	@Column("ZDLB")
	private String zdlb;
	/**
	 * 主键
	 */
	@Id
    @GeneratedValue(generator="idGenerator")
	@Column("ID")
	private String id;
	/**
	 * 描述
	 */
	@Column("MS")
	private String ms;
	/**
	 * 简拼
	 */
	@Column("JP")
	private String jp;
	/**
	 * 父节点
	 */
	@Column("UPNODE")
	private String upnode;
	/**
	 * 更新时间
	 */
	@Column("GXSJ")
	private String gxsj;
	/**
	 * 名称
	 */
	@Column("MC")
	private String mc;
	/**
	 * 是否缓存
	 */
	@Column("CACHE")
	private String cache;
	/**
	 * 类别SQL;当次SQL为空时，字典默认在此统一字典表中，有SQL则通过SQL获取字典
	 */
	@Column("LBSQL")
	private String lbsql;
	/**
	 * 创建人姓名
	 */
	@Column("CJRXM")
	private String cjrxm;
	/**
	 * 创建人代码@SYS_COMMON_USER
	 */
	@Column("CJRDM")
	private String cjrdm;
	/**
	 * 代码
	 */
	@Column("DM")
	private String dm;
	/**
	 * 创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("CJRDWDM")
	private String cjrdwdm;
	/**
	 * 创建人单位名称
	 */
	@Column("CJRDWMC")
	private String cjrdwmc;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("YXX")
	private String yxx;
	/**
	 * 创建时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 标准字典;用于数据标准化等场景，如性别可以有几套字典，然后关联一个标准字典,进一步通过mc关联
	 */
	@Column("BZZD")
	private String bzzd;
	/**
	 * 排序;建议排序都按10、20、30的方式排序，方便修改穿插
	 */
	@Column("PX")
	private BigDecimal px;
	/**
	 * 数据来源
	 */
	@Column("SJLY")
	private String sjly;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("KZXX")
	private String kzxx;
	/**
	 * 全拼
	 */
	@Column("QP")
	private String qp;
    /**
    * 其他参数
    */
    private String otherParam;
    /**
    * 搜索框需要翻译的值
    */
    private String searchValue;
    /**
    * 搜索关键字
    */
    private String searchKey;
    /**
    * 返回结果是否进行JSON格式化
    */
    private boolean jsongsh;
	/**
	 * 子节点
	 */
	private transient List<SysSjglTyzd> children;
}
