/**
* by jingma 2021-10-02
*/
package cn.benma666.domain;

import cn.benma666.sjzt.SjsjEntity;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.math.BigDecimal;

/**
 * 系统-日志-数据上传错误
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "SYS_LOG_SJSCCW")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysLogSjsccw extends BasicBean{

	/**
	 * 序列化
	 */
	private static final long serialVersionUID = 1L;

	public SysLogSjsccw(String sjwj, String sjz, String sjlm, String sjh, String sjdx, String sjl,String cwxx,String qqid) {
		this.sjwj = sjwj;
		this.sjz = sjz;
		this.sjlm = sjlm;
		this.sjh = sjh;
		this.sjdx = sjdx;
		this.sjl = sjl;
		this.cwxx = cwxx;
		this.qqid = qqid;
	}

	/**
	 * 主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("ID")
	private String id;
	/**
	 * 数据文件
	 */
	@Column("SJWJ")
	private String sjwj;
	/**
	 * 数据值
	 */
	@Column("SJZ")
	private String sjz;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("KZXX")
	private String kzxx;
	/**
	 * 创建人代码@SYS_COMMON_USER
	 */
	@Column("CJRDM")
	private String cjrdm;
	/**
	 * 创建人姓名
	 */
	@Column("CJRXM")
	private String cjrxm;
	/**
	 * 错误信息
	 */
	@Column("CWXX")
	private String cwxx;
	/**
	 * 创建人单位名称
	 */
	@Column("CJRDWMC")
	private String cjrdwmc;
	/**
	 * 创建时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("CJRDWDM")
	private String cjrdwdm;
	/**
	 * 数据列名
	 */
	@Column("SJLM")
	private String sjlm;
	/**
	 * 排序
	 */
	@Column("PX")
	private BigDecimal px;
	/**
	 * 数据行
	 */
	@Column("SJH")
	private String sjh;
	/**
	 * 数据对象
	 */
	@Column("SJDX")
	private String sjdx;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("YXX")
	private String yxx;
	/**
	 * 数据列
	 */
	@Column("SJL")
	private String sjl;
	/**
	 * 更新时间
	 */
	@Column("GXSJ")
	private String gxsj;
	/**
	 * 请求ID
	 */
	@Column("QQID")
	private String qqid;
}
