/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt.rabbit;

import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.iframe.InterfaceLog;
import cn.benma666.sjzt.BasicSjzt;
import cn.benma666.sjzt.IFile;
import cn.benma666.sjzt.rabbit.RabbitMQFile;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.UUID;

class MQConsumer
extends DefaultConsumer {
    SysSjglZnjh znjhConfig;
    InterfaceLog znjhJob;
    BasicSjzt sjzt;

    public MQConsumer(Channel channel, BasicSjzt sjzt, SysSjglZnjh znjhConfig, InterfaceLog znjhJob) {
        super(channel);
        this.sjzt = sjzt;
        this.znjhJob = znjhJob;
        this.znjhConfig = znjhConfig;
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        long deliveryTag = envelope.getDeliveryTag();
        try {
            IFile iFile = this.callBack(consumerTag, envelope, properties, body);
            this.znjhConfig.getTp().run(() -> this.sjzt.getZnjh().znjh(this.znjhConfig, this.znjhJob, iFile));
            super.getChannel().basicAck(deliveryTag, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                super.getChannel().basicNack(deliveryTag, false, true);
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }

    private IFile callBack(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        GetResponse response = new GetResponse(envelope, properties, body, body.length);
        return new RabbitMQFile("/", this.sjzt, UUID.randomUUID().toString(), response);
    }

    public SysSjglZnjh getZnjhConfig() {
        return this.znjhConfig;
    }

    public void setZnjhConfig(SysSjglZnjh znjhConfig) {
        this.znjhConfig = znjhConfig;
    }

    public InterfaceLog getZnjhJob() {
        return this.znjhJob;
    }

    public void setZnjhJob(InterfaceLog znjhJob) {
        this.znjhJob = znjhJob;
    }

    public BasicSjzt getSjzt() {
        return this.sjzt;
    }

    public void setSjzt(BasicSjzt sjzt) {
        this.sjzt = sjzt;
    }
}

