/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt.ftp;

import cn.benma666.exception.MyException;
import cn.benma666.myutils.FileUtil;
import cn.benma666.sjzt.ftp.Ftp;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;

public class FtpInputStream
extends InputStream {
    private InputStream is;
    private Ftp ftp;
    private FTPClient ftpClient;
    private boolean closed = false;

    public FtpInputStream(InputStream is, Ftp ftp, FTPClient ftpClient) {
        this.is = is;
        this.ftp = ftp;
        this.ftpClient = ftpClient;
    }

    @Override
    public int read() throws IOException {
        if (this.isClosed()) {
            throw new MyException("\u8be5\u8f93\u5165\u6d41\u5df2\u5173\u95ed");
        }
        return this.is.read();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        super.close();
        FileUtil.closeStream(this.is);
        this.ftp.returnClient(this.ftpClient);
        this.setClosed(true);
    }

    public void setIs(InputStream is) {
        this.is = is;
    }

    public void setFtp(Ftp ftp) {
        this.ftp = ftp;
    }

    public void setFtpClient(FTPClient ftpClient) {
        this.ftpClient = ftpClient;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public InputStream getIs() {
        return this.is;
    }

    public Ftp getFtp() {
        return this.ftp;
    }

    public FTPClient getFtpClient() {
        return this.ftpClient;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

