/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt.ftp;

import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.Conf;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.ClassUtil;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.BasicSjzt;
import cn.benma666.sjzt.IFile;
import cn.benma666.sjzt.SjztExecRunnable;
import cn.benma666.sjzt.SjztPooledObjectFactory;
import cn.benma666.sjzt.ftp.FtpFile;
import cn.benma666.sjzt.ftp.FtpInputStream;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class Ftp
extends BasicSjzt {
    public static Pattern ftpUrlZz = Pattern.compile("^(ftp://)?([^:]*)(:(\\d+))?$");
    public static Ftp ftp;
    private String root;
    private GenericObjectPool objectPool;

    private Ftp(String name, SysSjglSjzt sjzt) {
        this(name, Ftp.createFtpFactory(sjzt));
    }

    private Ftp(String name, SjztPooledObjectFactory ftpFactory) {
        super(name);
        GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
        conf.setTestOnCreate(true);
        conf.setTestOnBorrow(true);
        conf.setMinIdle(1);
        conf.setMaxIdle(3);
        conf.setMaxTotal(5);
        conf.setMaxWait(Duration.ofMinutes(10L));
        this.setSjzt(ftpFactory.getSjzt());
        ClassUtil.plMethodInvoke(conf, this.getSjzt().getKzxxObj().getJSONObject("ljcpz"));
        this.objectPool = new GenericObjectPool((PooledObjectFactory)ftpFactory, conf);
        FTPClient ftpClient = null;
        try {
            ftpClient = this.borrowClient();
            this.root = Ftp.valByDef(Ftp.pwd(ftpClient), "/");
            this.log.info("{}\u6839\u8def\u5f84\uff1a{}", (Object)name, (Object)this.root);
        }
        catch (Exception e) {
            throw new MyException(name + "\u521d\u59cb\u5316\u5931\u8d25", e);
        }
        finally {
            this.returnClient(ftpClient);
        }
        if (ftp == null) {
            ftp = this;
        }
        cache.put(name, (Object)this);
    }

    public static Ftp use(String name) {
        return Ftp.use(name, Ftp.getSjzt(name));
    }

    public static synchronized Ftp use(String name, SysSjglSjzt sjzt) {
        Ftp ftp = (Ftp)cache.get((Object)name);
        if (ftp == null) {
            ftp = new Ftp(name, sjzt);
        }
        return ftp;
    }

    public static Result cszt(SysSjglSjzt sjzt) {
        try {
            Ftp.parseSjztFtp(sjzt);
            FTPClient fc = Ftp.createClient(sjzt);
            fc.printWorkingDirectory();
            fc.disconnect();
            return Ftp.success("\u6d4b\u8bd5\u6210\u529f");
        }
        catch (Throwable t) {
            return Ftp.failed("\u8f7d\u4f53\u6d4b\u8bd5\u4e0d\u901a\u8fc7\uff1a" + t.getMessage());
        }
    }

    public static boolean validateClient(SysSjglSjzt sjzt, Object client) {
        try {
            FTPClient ftpClient = (FTPClient)client;
            if (!ftpClient.isConnected()) {
                return false;
            }
            slog.trace("\u6a21\u5f0f\uff1a{},\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6:{}\uff0c\u9ed8\u8ba4\u8d85\u65f6\u65f6\u957f\uff1a{},\u7f13\u5b58\u5927\u5c0f\uff1a{},\u7f16\u7801\uff1a{},AutodetectUTF8:{},OptsUtf8:{}", new Object[]{ftpClient.getDataConnectionMode(), ftpClient.getSoTimeout(), ftpClient.getDefaultTimeout(), ftpClient.getBufferSize(), ftpClient.getControlEncoding(), ftpClient.getAutodetectUTF8(), FTPReply.isPositiveCompletion((int)ftpClient.sendCommand("OPTS UTF8", "ON"))});
            return StringUtil.isNotBlank((String)ftpClient.printWorkingDirectory());
        }
        catch (Throwable t) {
            slog.debug("ftp\u9a8c\u8bc1\u65e0\u6548\uff1a{}", (Object)sjzt.getMc(), (Object)t);
            return false;
        }
    }

    public static void destroyClient(SysSjglSjzt sjzt, Object client) throws Exception {
        FTPClient ftpClient = (FTPClient)client;
        ftpClient.disconnect();
    }

    public static FTPClient createClient(SysSjglSjzt sjzt) {
        FTPClient ftpClient = new FTPClient();
        FTPClientConfig conf = null;
        ftpClient.setRemoteVerificationEnabled(false);
        ftpClient.setAutodetectUTF8(true);
        ftpClient.setControlEncoding("UTF-8");
        JSONObject ftppz = sjzt.getKzxxObj().getJSONObject("ftppz");
        if (ftppz != null) {
            if (!StringUtil.isBlank((String)ftppz.getString("$.FTPClientConfig.serverSystemKey"))) {
                conf = new FTPClientConfig(ftppz.getString("$.FTPClientConfig.serverSystemKey"));
            }
            ClassUtil.plMethodInvoke(ftpClient, ftppz.getJSONObject("FTPClient"));
            if (conf != null) {
                ClassUtil.plMethodInvoke(conf, ftppz.getJSONObject("FTPClientConfig"));
                ftpClient.configure(conf);
            }
        }
        return Ftp.createClient(ftpClient, sjzt.getIp(), sjzt.getPort(), sjzt.getYhm(), sjzt.getMm(), TypeUtils.castToBoolean((Object)Conf.getVal("benma666.debug")), sjzt);
    }

    public static FTPClient createClient(final FTPClient ftpClient, String host, int port, String username, String password, boolean isPrintCommmand, SysSjglSjzt sjzt) {
        if (StringUtil.valByDef(isPrintCommmand, false).booleanValue()) {
            ftpClient.addProtocolCommandListener(new ProtocolCommandListener(){

                public void protocolCommandSent(ProtocolCommandEvent protocolCommandEvent) {
                    slog.trace(ftpClient.getRemoteAddress() + ":" + protocolCommandEvent.getMessage());
                }

                public void protocolReplyReceived(ProtocolCommandEvent protocolCommandEvent) {
                    slog.trace(ftpClient.getRemoteAddress() + ":" + protocolCommandEvent.getMessage());
                }
            });
        }
        try {
            ftpClient.connect(host, port);
            if (FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                if (!ftpClient.login(username, password)) {
                    throw new MyException("\u8d26\u53f7\u5bc6\u7801\u767b\u5f55\u5931\u8d25");
                }
            } else {
                if (ftpClient.isConnected()) {
                    ftpClient.disconnect();
                }
                throw new MyException("\u8fde\u63a5\u5931\u8d25");
            }
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            ClassUtil.plMethodInvoke(ftpClient, sjzt.getKzxxObj().getJSONObject("$.ftppz.FTPClientDlh"));
            slog.trace("\u6a21\u5f0f\uff1a{},\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6:{}\uff0c\u9ed8\u8ba4\u8d85\u65f6\u65f6\u957f\uff1a{},\u7f13\u5b58\u5927\u5c0f\uff1a{},\u7f16\u7801\uff1a{},AutodetectUTF8:{},OptsUtf8:{}", new Object[]{ftpClient.getDataConnectionMode(), ftpClient.getSoTimeout(), ftpClient.getDefaultTimeout(), ftpClient.getBufferSize(), ftpClient.getControlEncoding(), ftpClient.getAutodetectUTF8(), FTPReply.isPositiveCompletion((int)ftpClient.sendCommand("OPTS UTF8", "ON"))});
        }
        catch (Exception e) {
            throw new MyException("ftp\u767b\u5f55\u5931\u8d25\uff1a" + host + "," + port + "," + username, e);
        }
        return ftpClient;
    }

    public void returnClient(FTPClient ftpClient) {
        this.log.trace("\u91ca\u653eftp\u56de\u8fde\u63a5\u6c60\uff1a{}", (Object)this.name);
        if (ftpClient != null) {
            this.objectPool.returnObject((Object)ftpClient);
        }
    }

    public FTPClient borrowClient() throws Exception {
        this.log.trace("\u4ece\u8fde\u63a5\u6c60\u83b7\u53d6ftp\uff1a{}", (Object)this.name);
        Object r = StringUtil.requireNonNull(this.objectPool, "\u5bf9\u8c61\u6c60\u4e3a\u7a7a" + this.name).borrowObject();
        return (FTPClient)StringUtil.requireNonNull(r, "ftp\u8fde\u63a5\u6c60\u8fd4\u56de\u7684\u5ba2\u6237\u7aef\u4e3a\u7a7a" + this.name);
    }

    @Override
    public void close() throws IOException {
        if (!this.objectPool.isClosed()) {
            this.objectPool.close();
        }
        cache.remove((Object)this.name);
        if (this == ftp) {
            ftp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object exec(SjztExecRunnable<FTPClient> exec) throws Exception {
        FTPClient ftpClient = null;
        try {
            ftpClient = this.borrowClient();
            Object object = exec.exec(ftpClient);
            return object;
        }
        finally {
            this.returnClient(ftpClient);
        }
    }

    @Override
    public List<IFile> listFiles(SysSjglZnjh znjhConfig) throws Exception {
        return (List)this.exec(ftpClient -> this.listFiles(znjhConfig.getSrml(), (FTPClient)ftpClient, znjhConfig));
    }

    private List<IFile> listFiles(String path, FTPClient ftpClient, SysSjglZnjh znjhConfig) throws Exception {
        FTPFile[] files;
        ArrayList<IFile> list = new ArrayList<IFile>();
        String p = FileUtil.getFilePath(this.root, path);
        this.log.trace("\u5f00\u59cb\u904d\u5386\u76ee\u5f55\uff1a{}", (Object)p);
        for (FTPFile file : files = ftpClient.listFiles(p)) {
            long t;
            this.log.trace("\u904d\u5386\u5230\u6587\u4ef6\uff1a{}", (Object)file.getName());
            if (file.isFile()) {
                long l = t = file.getTimestamp() == null ? 0L : file.getTimestamp().getTimeInMillis();
                if (this.sftg(znjhConfig, t, file.getName())) continue;
                list.add(new FtpFile(path, file, this));
                continue;
            }
            if (!file.isDirectory() || file.getName().contains(".")) continue;
            if (znjhConfig.isBlbhml()) {
                long l = t = file.getTimestamp() == null ? 0L : file.getTimestamp().getTimeInMillis();
                if (!this.sftg(znjhConfig, t, file.getName())) {
                    list.add(new FtpFile(path, file, this));
                }
            }
            if (!znjhConfig.isDgbl()) continue;
            list.addAll(this.listFiles(FileUtil.getFilePath(path, file.getName()), ftpClient, znjhConfig));
        }
        return list;
    }

    @Override
    public InputStream getInputStream(IFile file) throws Exception {
        int i = 0;
        InputStream is = null;
        FTPClient ftpClient = null;
        try {
            ftpClient = this.borrowClient();
            while (is == null && ++i < 20) {
                try {
                    is = ftpClient.retrieveFileStream(this.getAbsolutePath(file));
                }
                catch (Exception e) {
                    slog.trace("\u83b7\u53d6\u8f93\u5165\u6d41\u5f02\u5e38\uff1a{}", (Object)file.getAbsolutePath(), (Object)e);
                }
                Thread.sleep(100L);
            }
            if (is == null) {
                throw new MyException("\u6ca1\u6709\u83b7\u53d6\u5230\u8f93\u5165\u6d41\uff1a" + this.getAbsolutePath(file));
            }
            return new FtpInputStream(is, this, ftpClient);
        }
        catch (Throwable t) {
            this.returnClient(ftpClient);
            throw new MyException("\u83b7\u53d6\u8f93\u5165\u6d41\u5f02\u5e38\uff1a" + this.getAbsolutePath(file), t);
        }
    }

    @Override
    public boolean delete(IFile file) throws Exception {
        return (Boolean)this.exec(ftpClient -> ftpClient.deleteFile(this.getAbsolutePath(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(InputStream is, IFile file) throws Exception {
        FTPClient ftpClient = null;
        try {
            ftpClient = this.borrowClient();
            this.makeDir(FileUtil.getFilePath(file.getGzml(), file.getParent()), ftpClient);
            int i = 0;
            while (i++ < 20 && !ftpClient.storeFile(this.getAbsolutePath(file) + ".unimastmp", is)) {
                Thread.sleep(100L);
            }
            if (i > 20) {
                throw new MyException("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25");
            }
            i = 0;
            while (i++ < 20 && !ftpClient.rename(this.getAbsolutePath(file) + ".unimastmp", this.getAbsolutePath(file))) {
                Thread.sleep(100L);
            }
            if (i > 20) {
                throw new MyException("\u6587\u4ef6\u91cd\u547d\u540d\u5931\u8d25\uff1a" + this.getAbsolutePath(file));
            }
        }
        finally {
            this.returnClient(ftpClient);
            FileUtil.closeStream(is);
        }
        return true;
    }

    @Override
    public String getRootPath() {
        return this.root;
    }

    @Override
    public long getSize(IFile file) throws Exception {
        return (Long)this.exec(ftpClient -> {
            String path = this.getAbsolutePath(file);
            long size = 0L;
            int i = 0;
            while (size == 0L && i < 20) {
                ++i;
                try {
                    size = TypeUtils.castToLong((Object)ftpClient.getSize(path));
                }
                catch (Exception e) {
                    slog.trace("\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u5931\u8d25\uff1a" + path, (Throwable)e);
                }
            }
            return size;
        });
    }

    public File download(String ftpPath, String fileName, String localPath) {
        FileOutputStream is = null;
        File localFile = new File(FileUtil.getFilePath(localPath, fileName));
        FTPClient ftpClient = null;
        try {
            ftpClient = this.borrowClient();
            this.setPath(ftpPath, ftpClient);
            File f = new File(localPath);
            if (!f.exists() && !f.mkdirs()) {
                throw new MyException("\u76ee\u5f55\u521b\u5efa\u5931\u8d25\uff1a" + f.getAbsolutePath());
            }
            is = new FileOutputStream(localFile);
            ftpClient.retrieveFile(Ftp.zhFileName(fileName), (OutputStream)is);
        }
        catch (Exception e) {
            try {
                this.log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                throw new MyException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                FileUtil.closeStream(is);
                this.returnClient(ftpClient);
                throw throwable;
            }
        }
        FileUtil.closeStream(is);
        this.returnClient(ftpClient);
        return localFile;
    }

    public boolean upload(String ftpPath, String filename, InputStream input) {
        FTPClient ftpClient = null;
        try {
            ftpClient = this.borrowClient();
            this.makeDir(ftpPath, ftpClient);
            this.setPath(ftpPath, ftpClient);
            boolean bl = ftpClient.storeFile(Ftp.zhFileName(filename), input);
            return bl;
        }
        catch (Exception e) {
            this.log.error("\u4e0a\u4f20ftp\u5931\u8d25", (Throwable)e);
            throw new MyException("\u4e0a\u4f20ftp\u5931\u8d25", e);
        }
        finally {
            FileUtil.closeStream(input);
            this.returnClient(ftpClient);
        }
    }

    public boolean delete(String ftpPath, String fileName) {
        FTPClient ftpClient = null;
        try {
            ftpClient = this.borrowClient();
            boolean bl = ftpClient.deleteFile(Ftp.zhFileName(FileUtil.getFilePath(this.root, ftpPath, fileName)));
            return bl;
        }
        catch (Exception e) {
            this.log.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new MyException("\u5220\u9664\u6587\u4ef6\u5931\u8d25", e);
        }
        finally {
            this.returnClient(ftpClient);
        }
    }

    public List<File> downloadPath(String ftpPath, String localPath) {
        FTPClient ftpClient = null;
        try {
            ftpClient = this.borrowClient();
            List<File> list = this.downloadPath(ftpPath, localPath, ftpClient);
            return list;
        }
        catch (Exception e) {
            this.log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            throw new MyException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", e);
        }
        finally {
            this.returnClient(ftpClient);
        }
    }

    public List<File> downloadPath(String ftpPath, String localPath, FTPClient ftpClient) {
        FileOutputStream os = null;
        ArrayList<File> fileList = new ArrayList<File>();
        try {
            FTPFile[] fs;
            File lo = new File(localPath);
            if (!lo.exists() && !lo.mkdirs()) {
                throw new MyException("\u76ee\u5f55\u521b\u5efa\u5931\u8d25\uff1a" + lo.getAbsolutePath());
            }
            this.setPath(ftpPath, ftpClient);
            for (FTPFile ff : fs = ftpClient.listFiles()) {
                if (ff.isDirectory()) {
                    fileList.addAll(this.downloadPath(FileUtil.getFilePath(ftpPath, ff.getName()), FileUtil.getFilePath(localPath, ff.getName()), ftpClient));
                    continue;
                }
                File localFile = new File(FileUtil.getFilePath(localPath, ff.getName()));
                os = new FileOutputStream(localFile);
                ftpClient.retrieveFile(Ftp.zhFileName(ff.getName()), (OutputStream)os);
                fileList.add(localFile);
            }
        }
        catch (Exception e) {
            this.log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            throw new MyException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", e);
        }
        finally {
            FileUtil.closeStream(os);
        }
        return fileList;
    }

    public void uploadPath(String ftpPath, String localPath) {
        File file = new File(localPath);
        try {
            File[] list;
            if (file.isFile()) {
                FileInputStream in = new FileInputStream(file);
                this.upload(ftpPath, file.getName(), in);
            } else if (file.isDirectory() && (list = file.listFiles()) != null) {
                for (File f : list) {
                    String fp = ftpPath;
                    if (f.isDirectory()) {
                        fp = FileUtil.getFilePath(ftpPath, f.getName());
                    }
                    this.uploadPath(fp, f.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u6587\u4ef6\u627e\u4e0d\u5230", (Throwable)e);
            throw new MyException("\u6587\u4ef6\u627e\u4e0d\u5230", e);
        }
    }

    public void deletePath(String ftpPath) {
        FTPClient ftpClient = null;
        try {
            FTPFile[] ftpFiles;
            ftpClient = this.borrowClient();
            for (FTPFile file : ftpFiles = ftpClient.listFiles(FileUtil.getFilePath(this.root, ftpPath))) {
                if (file.isDirectory()) {
                    this.deletePath(FileUtil.getFilePath(ftpPath, file.getName()));
                    continue;
                }
                ftpClient.deleteFile(Ftp.zhFileName(FileUtil.getFilePath(this.root, ftpPath, file.getName())));
            }
            ftpClient.removeDirectory(Ftp.zhFileName(FileUtil.getFilePath(this.root, ftpPath)));
        }
        catch (Exception e) {
            this.log.error("\u4eceFTP\u670d\u52a1\u5668\u5220\u9664\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            throw new MyException("\u4eceFTP\u670d\u52a1\u5668\u5220\u9664\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            this.returnClient(ftpClient);
        }
    }

    public void upload(String ftpPath, List<File> files) {
        FileInputStream is = null;
        FTPClient ftpClient = null;
        try {
            ftpClient = this.borrowClient();
            this.makeDir(ftpPath, ftpClient);
            for (File file : files) {
                is = new FileInputStream(file);
                ftpClient.storeFile(Ftp.zhFileName(FileUtil.getFilePath(this.root, ftpPath, file.getName())), (InputStream)is);
                is.close();
            }
        }
        catch (Exception e) {
            this.log.error("\u4e0a\u4f20FTP\u6587\u4ef6\u5f02\u5e38:", (Throwable)e);
            throw new MyException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", e);
        }
        finally {
            FileUtil.closeStream(is);
            this.returnClient(ftpClient);
        }
    }

    public void makeDir(String ftpPath) throws Exception {
        FTPClient ftpClient = null;
        try {
            ftpClient = this.borrowClient();
            this.makeDir(ftpPath, ftpClient);
        }
        finally {
            this.returnClient(ftpClient);
        }
    }

    public void makeDir(String ftpPath, FTPClient ftpClient) {
        try {
            if (this.existDir(ftpPath, ftpClient)) {
                return;
            }
            File f = new File(ftpPath);
            if (!this.existDir(FileUtil.getFilePath(f.getParent()), ftpClient)) {
                this.makeDir(FileUtil.getFilePath(f.getParent()), ftpClient);
            }
            if (!ftpClient.makeDirectory(Ftp.zhFileName(FileUtil.getFilePath(this.root, ftpPath)))) {
                throw new MyException("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff1a" + ftpPath);
            }
        }
        catch (Exception ex) {
            slog.error("\u8fdc\u7a0bFTP\u751f\u6210\u76ee\u5f55\u5f02\u5e38:" + ftpPath, (Throwable)ex);
            throw new MyException("\u8fdc\u7a0bFTP\u751f\u6210\u76ee\u5f55\u5f02\u5e38:" + ftpPath, ex);
        }
    }

    public void existDir(String ftpPath) throws Exception {
        FTPClient ftpClient = null;
        try {
            ftpClient = this.borrowClient();
            this.existDir(ftpPath, ftpClient);
        }
        finally {
            this.returnClient(ftpClient);
        }
    }

    public boolean existDir(String ftpPath, FTPClient ftpClient) {
        try {
            this.setPath(ftpPath, ftpClient);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static String zhFileName(String fileName) {
        return fileName;
    }

    private void setPath(String ftpPath, FTPClient ftpClient) throws Exception {
        String fp = FileUtil.getFilePath(this.root, ftpPath);
        boolean j = false;
        ftpClient.changeWorkingDirectory(Ftp.zhFileName(fp));
        String pwd = Ftp.pwd(ftpClient);
        if (pwd == null) {
            throw new MyException("\u83b7\u53d6\u5f53\u524d\u76ee\u5f55\u5931\u8d25\uff1a" + ftpPath);
        }
        if (!fp.equals(pwd)) {
            throw new MyException("\u5207\u6362\u76ee\u5f55\u5931\u8d25\uff1a" + fp + "->" + pwd);
        }
    }

    public static String pwd(FTPClient ftpClient) {
        try {
            String pwd = ftpClient.printWorkingDirectory();
            int i = 0;
            while (pwd == null && i++ < 20) {
                Thread.sleep(100L);
                pwd = ftpClient.printWorkingDirectory();
            }
            return pwd;
        }
        catch (Exception e) {
            throw new MyException("\u83b7\u53d6\u76ee\u5f55\u5931\u8d25", e);
        }
    }

    public static SjztPooledObjectFactory createFtpFactory(SysSjglSjzt sjzt) {
        Ftp.parseSjztFtp(sjzt);
        return new SjztPooledObjectFactory(sjzt);
    }

    public static SysSjglSjzt parseSjztFtp(SysSjglSjzt sjztObj) {
        Matcher m = ftpUrlZz.matcher(sjztObj.getLjc());
        if (!m.find()) {
            throw new MyException("ftp\u8fde\u63a5\u4e32\u89e3\u6790\u51fa\u9519");
        }
        sjztObj.setIp(m.group(2));
        sjztObj.setPort(TypeUtils.castToInt((Object)Ftp.valByDef(m.group(4), 21)));
        return sjztObj;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setObjectPool(GenericObjectPool objectPool) {
        this.objectPool = objectPool;
    }

    public String getRoot() {
        return this.root;
    }

    public GenericObjectPool getObjectPool() {
        return this.objectPool;
    }
}

