/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt.fastdfs;

import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.BasicObject;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;

public class FastDFSClient
extends BasicObject {
    private TrackerServer trackerServer;
    private StorageClient storageClient;

    public FastDFSClient(SysSjglSjzt sjzt) {
        this.storageClient = this.CreateStorageClient(sjzt);
    }

    public void close() {
        try {
            this.trackerServer.close();
        }
        catch (IOException e) {
            slog.debug("fastdfs\u8fde\u63a5\u5173\u95ed\u5931\u8d25", (Throwable)e);
        }
    }

    public StorageClient CreateStorageClient(SysSjglSjzt sjzt) {
        JSONObject kzxx = sjzt.getKzxxObj();
        Properties properties = new Properties();
        properties.setProperty("fastdfs.connect_timeout_in_seconds", "2");
        properties.setProperty("fastdfs.network_timeout_in_seconds", "30");
        properties.setProperty("fastdfs.charset", "UTF-8");
        properties.setProperty("fastdfs.http_tracker_http_port", "8080");
        properties.setProperty("fastdfs.http_anti_steal_token", "no");
        properties.setProperty("fastdfs.http_secret_key", "FastDFS1234567890");
        properties.setProperty("fastdfs.tracker_servers", sjzt.getLjc());
        if (kzxx.containsKey((Object)"fastdfsConfig")) {
            properties.putAll((Map<?, ?>)sjzt.getKzxxObj().getJSONObject("fastdfsConfig"));
        }
        try {
            ClientGlobal.initByProperties((Properties)properties);
            TrackerClient trackerClient = new TrackerClient();
            this.trackerServer = trackerClient.getConnection();
            StorageServer storageServer = trackerClient.getStoreStorage(this.trackerServer);
            return new StorageClient(this.trackerServer, storageServer);
        }
        catch (Exception e) {
            throw new MyException("fastDFS\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    public TrackerServer getTrackerServer() {
        return this.trackerServer;
    }

    public StorageClient getStorageClient() {
        return this.storageClient;
    }

    public void setTrackerServer(TrackerServer trackerServer) {
        this.trackerServer = trackerServer;
    }

    public void setStorageClient(StorageClient storageClient) {
        this.storageClient = storageClient;
    }
}

