/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt.fastdfs;

import cn.benma666.domain.SysSjglFile;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.BusinessException;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.InterfaceLog;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.HttpUtil;
import cn.benma666.sjzt.BasicSjzt;
import cn.benma666.sjzt.DbFile;
import cn.benma666.sjzt.IFile;
import cn.benma666.sjzt.SjztExecRunnable;
import cn.benma666.sjzt.SjztPooledObjectFactory;
import cn.benma666.sjzt.fastdfs.FastDFSClient;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.time.Duration;
import java.util.List;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.FileInfo;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.TrackerServer;

public class FastDFS
extends BasicSjzt {
    public static final String GROUP_NAME = "groupName";
    private static FastDFS fastDFS = null;
    private final GenericObjectPool fastDFSObjectPool;

    protected FastDFS(String name, SysSjglSjzt sjzt) {
        super(name, sjzt);
        GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
        conf.setTestOnCreate(true);
        conf.setTestOnBorrow(true);
        conf.setMinIdle(2);
        conf.setMaxIdle(5);
        conf.setMaxTotal(20);
        conf.setMaxWait(Duration.ofSeconds(300L));
        this.fastDFSObjectPool = new GenericObjectPool((PooledObjectFactory)new SjztPooledObjectFactory(sjzt), conf);
        FastDFSClient fastDFSClient = null;
        try {
            fastDFSClient = (FastDFSClient)this.fastDFSObjectPool.borrowObject();
        }
        catch (Exception e) {
            throw new MyException(name + "\u521d\u59cb\u5316\u5931\u8d25", e);
        }
        finally {
            this.fastDFSObjectPool.returnObject((Object)fastDFSClient);
        }
        if (fastDFS == null) {
            fastDFS = this;
        }
        cache.put(name, (Object)this);
    }

    public static FastDFS use(String name) {
        FastDFS sjzt = (FastDFS)cache.get((Object)name);
        if (sjzt == null) {
            sjzt = new FastDFS(name, FastDFS.getSjzt(name));
        }
        return sjzt;
    }

    public Object exec(SjztExecRunnable<FastDFSClient> exec) {
        FastDFSClient fastDFSClient = null;
        try {
            fastDFSClient = (FastDFSClient)this.fastDFSObjectPool.borrowObject();
            Object object = exec.exec(fastDFSClient);
            return object;
        }
        catch (Exception e) {
            throw new MyException("FastDFS\u6267\u884c\u5f02\u5e38", e);
        }
        finally {
            if (fastDFSClient != null) {
                this.fastDFSObjectPool.returnObject((Object)fastDFSClient);
            }
        }
    }

    public static Result cszt(SysSjglSjzt sjzt) {
        try {
            FastDFSClient dfsClient = new FastDFSClient(sjzt);
            TrackerServer trackerServer = dfsClient.getTrackerServer();
            boolean r = ProtoCommon.activeTest((Socket)trackerServer.getSocket());
            if (r) {
                return FastDFS.success("\u6d4b\u8bd5\u6210\u529f");
            }
            return FastDFS.failed("\u8f7d\u4f53\u6d4b\u8bd5\u4e0d\u901a\u8fc7\uff1a" + sjzt.getMc());
        }
        catch (Throwable var2) {
            slog.debug("{}\u6d4b\u8bd5\u5931\u8d25", (Object)sjzt, (Object)var2);
            return FastDFS.failed("\u8f7d\u4f53\u6d4b\u8bd5\u4e0d\u901a\u8fc7\uff1a" + var2.getMessage());
        }
    }

    public static boolean validateClient(SysSjglSjzt sjzt, Object client) {
        try {
            FastDFSClient fastDFSClient = (FastDFSClient)client;
            TrackerServer trackerServer = fastDFSClient.getTrackerServer();
            return ProtoCommon.activeTest((Socket)trackerServer.getSocket());
        }
        catch (IOException e) {
            slog.debug("fastDFS\u9a8c\u8bc1\u65e0\u6548\uff1a{}", (Object)sjzt.getMc(), (Object)e);
            return false;
        }
    }

    public static void destroyClient(SysSjglSjzt sjzt, Object client) throws Exception {
        FastDFSClient fastDFSClient = (FastDFSClient)client;
        fastDFSClient.close();
    }

    public static FastDFSClient createClient(SysSjglSjzt sjzt) {
        return new FastDFSClient(sjzt);
    }

    @Override
    public List<IFile> listFiles(SysSjglZnjh znjhConfig) {
        throw new MyException("\u4e0d\u652f\u6301listFiles");
    }

    @Override
    public InputStream getInputStream(IFile file) {
        return (InputStream)this.exec(fastDFSClient -> {
            HttpUtil hu = HttpUtil.builder().addRp("RequestMethod", "GET").build();
            return hu.getInputStream(this.getAbsolutePath(file));
        });
    }

    @Override
    public boolean delete(IFile file) {
        return (Boolean)this.exec(fastDFSClient -> {
            boolean s = false;
            DbFile dbfile = (DbFile)file;
            SysSjglFile fastDFSFile = dbfile.getFile();
            JSONObject kzxx = JSONObject.parseObject((String)fastDFSFile.getKzxx());
            StorageClient storageClient = fastDFSClient.getStorageClient();
            FileInfo fileInfo = storageClient.get_file_info(kzxx.getString(GROUP_NAME), fastDFSFile.getParent());
            if (FastDFS.isBlank(fileInfo)) {
                throw new MyException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + fastDFSFile);
            }
            int r = storageClient.delete_file(kzxx.getString(GROUP_NAME), fastDFSFile.getParent());
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(InputStream is, IFile file) {
        if (!(file instanceof DbFile)) {
            throw new MyException("fastdfs\u4fdd\u5b58\u6587\u4ef6\u53ea\u652f\u6301\u4f20\u5165DbFile");
        }
        try {
            boolean bl = (Boolean)this.exec(fastDFSClient -> {
                DbFile dbfile = (DbFile)file;
                SysSjglFile fastDFSFile = dbfile.getFile();
                String type = fastDFSFile.getWjlx();
                StorageClient storageClient = fastDFSClient.getStorageClient();
                NameValuePair[] meta_list = new NameValuePair[]{new NameValuePair("fileName", this.name), new NameValuePair("fileType", type)};
                String[] uploadResults = storageClient.upload_file(Utils.readByteArray((InputStream)is), type, meta_list);
                if (!FastDFS.isBlank(uploadResults)) {
                    String groupName = uploadResults[0];
                    String path = uploadResults[1];
                    JSONObject kzxx = new JSONObject();
                    kzxx.put(GROUP_NAME, (Object)groupName);
                    fastDFSFile.setSclj(this.getRootPath() + FileUtil.getFilePath("/", groupName, path));
                    fastDFSFile.setParent(path);
                    fastDFSFile.setKzxx(kzxx.toJSONString());
                    return true;
                }
                return false;
            });
            return bl;
        }
        finally {
            FileUtil.closeStream(is);
        }
    }

    @Override
    public String getRootPath() {
        return this.sjzt.getKzxxObj().getString("storage_servers");
    }

    @Override
    public String getAbsolutePath(IFile file) {
        DbFile dbfile = (DbFile)file;
        SysSjglFile fastDFSFile = dbfile.getFile();
        JSONObject kzxx = JSONObject.parseObject((String)fastDFSFile.getKzxx());
        return this.getRootPath() + FileUtil.getFilePath("/", kzxx.getString(GROUP_NAME), fastDFSFile.getParent());
    }

    @Override
    public long getSize(IFile file) {
        return (Long)this.exec(fastDFSClient -> {
            DbFile dbfile = (DbFile)file;
            SysSjglFile fastDFSFile = dbfile.getFile();
            JSONObject kzxx = JSONObject.parseObject((String)fastDFSFile.getKzxx());
            StorageClient storageClient = fastDFSClient.getStorageClient();
            FileInfo fileInfo = storageClient.get_file_info(kzxx.getString(GROUP_NAME), fastDFSFile.getParent());
            return fileInfo.getFileSize();
        });
    }

    @Override
    public void close() {
        if (!this.fastDFSObjectPool.isClosed()) {
            this.fastDFSObjectPool.close();
        }
        cache.remove((Object)this.name);
        if (this == fastDFS) {
            fastDFS = null;
        }
    }

    @Override
    public void sjztjt(SysSjglZnjh znjhConfig, InterfaceLog znjhJob) {
        throw new BusinessException("FastDFS\u4e0d\u652f\u6301\u76d1\u542c");
    }
}

