/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt;

import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.exception.MyException;
import cn.benma666.sjzt.BasicSjzt;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SjztPooledObjectFactory
extends BasePooledObjectFactory<Object> {
    private static final Logger slog = LoggerFactory.getLogger(SjztPooledObjectFactory.class);
    private final SysSjglSjzt sjzt;

    public SjztPooledObjectFactory(SysSjglSjzt sjzt) {
        this.sjzt = sjzt;
    }

    public Object create() throws Exception {
        slog.trace("\u7269\u7406\u521b\u5efaftp\u5ba2\u6237\u7aef\uff1a{}", (Object)this.sjzt.getMc());
        try {
            return BasicSjzt.createSjztClient(this.sjzt);
        }
        catch (Exception e) {
            throw new MyException("\u7269\u7406\u521b\u5efaftp\u5ba2\u6237\u7aef\u5931\u8d25\uff1a" + this.sjzt.getMc(), e);
        }
    }

    public boolean validateObject(PooledObject<Object> p) {
        try {
            return BasicSjzt.validateSjztClient(this.sjzt, p.getObject());
        }
        catch (Exception e) {
            slog.debug("\u5ba2\u6237\u7aef\u9a8c\u8bc1\u65e0\u6548\uff1a{}", (Object)this.sjzt.getMc(), (Object)e);
            return false;
        }
    }

    public PooledObject<Object> wrap(Object o) {
        return new DefaultPooledObject(o);
    }

    public void destroyObject(PooledObject<Object> p) throws Exception {
        slog.trace("\u7269\u7406\u91ca\u653eftp\u5ba2\u6237\u7aef");
        try {
            BasicSjzt.destroySjztClient(this.sjzt, p.getObject());
        }
        catch (Exception e) {
            slog.debug("\u5ba2\u6237\u7aef\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)this.sjzt.getMc(), (Object)e);
        }
    }

    public SysSjglSjzt getSjzt() {
        return this.sjzt;
    }
}

