/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt;

import cn.benma666.domain.SysSjglFile;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.BusinessException;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.InterfaceLog;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.HttpUtil;
import cn.benma666.sjzt.BasicSjzt;
import cn.benma666.sjzt.DbFile;
import cn.benma666.sjzt.IFile;
import cn.benma666.sjzt.SjztExecRunnable;
import cn.benma666.sjzt.SjztPooledObjectFactory;
import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class Minio
extends BasicSjzt {
    private static Minio minio = null;
    private final GenericObjectPool genericObjectPool;

    protected Minio(String name, SysSjglSjzt sjzt) {
        super(name, sjzt);
        GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
        conf.setTestOnCreate(true);
        conf.setTestOnBorrow(true);
        conf.setMinIdle(2);
        conf.setMaxIdle(5);
        conf.setMaxTotal(20);
        conf.setMaxWait(Duration.ofSeconds(300L));
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)new SjztPooledObjectFactory(sjzt), conf);
        MinioClient minioClient = null;
        try {
            minioClient = (MinioClient)this.genericObjectPool.borrowObject();
        }
        catch (Exception e) {
            this.log.error("minio\u6c60\u521d\u59cb\u5316\u5931\u8d25:{}", (Throwable)e);
            throw new MyException(name + "minio\u6c60\u521d\u59cb\u5316\u5931\u8d25", e);
        }
        finally {
            this.genericObjectPool.returnObject((Object)minioClient);
        }
        if (minio == null) {
            minio = this;
        }
        cache.put(name, (Object)this);
    }

    @Override
    public List<IFile> listFiles(SysSjglZnjh sysSjglZnjh) throws Exception {
        throw new MyException("\u4e0d\u652f\u6301listFiles");
    }

    public static Minio use(String name) {
        Minio sjzt = (Minio)cache.get((Object)name);
        if (sjzt == null) {
            sjzt = new Minio(name, Minio.getSjzt(name));
        }
        return sjzt;
    }

    public static MinioClient createClient(SysSjglSjzt sjzt) {
        try {
            return MinioClient.builder().endpoint(sjzt.getLjc()).credentials(sjzt.getYhm(), sjzt.getMm()).build();
        }
        catch (Exception e) {
            slog.error("minioClient\u521d\u59cb\u5316\u5931\u8d25:{}", (Throwable)e);
            throw new MyException("minioClient\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    public static void destroyClient(SysSjglSjzt sjzt, Object client) throws Exception {
    }

    @Override
    public InputStream getInputStream(IFile file) throws Exception {
        return (InputStream)this.exec(minio -> {
            HttpUtil hu = HttpUtil.builder().addRp("RequestMethod", "GET").build();
            return hu.getInputStream(this.getAbsolutePath(file));
        });
    }

    public Object exec(SjztExecRunnable<MinioClient> exec) {
        Object obj;
        MinioClient minioClient = null;
        try {
            minioClient = (MinioClient)this.genericObjectPool.borrowObject();
            obj = exec.exec(minioClient);
        }
        catch (Exception e) {
            throw new MyException("minio\u6267\u884c\u5f02\u5e38", e);
        }
        finally {
            if (minioClient != null) {
                this.genericObjectPool.returnObject((Object)minioClient);
            }
        }
        return obj;
    }

    @Override
    public boolean delete(IFile file) throws Exception {
        return (Boolean)this.exec(minioClient -> {
            DbFile dbfile = (DbFile)file;
            String bucketName = dbfile.getParent();
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(dbfile.getName())).build());
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(InputStream is, IFile file) throws Exception {
        if (!(file instanceof DbFile)) {
            throw new MyException("minio\u4fdd\u5b58\u6587\u4ef6\u53ea\u652f\u6301\u4f20\u5165DbFile");
        }
        try {
            boolean bl = (Boolean)this.exec(minioClient -> {
                DbFile dbfile = (DbFile)file;
                SysSjglFile sysSjglFile = dbfile.getFile();
                String bucketName = dbfile.getParent();
                String fileName = sysSjglFile.getWjm();
                if (!minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build())) {
                    minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
                }
                PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().object(fileName)).bucket(bucketName)).contentType("application/octet-stream").stream(is, (long)is.available(), -1L).build();
                minioClient.putObject(objectArgs);
                String fileUrl = bucketName + "/" + sysSjglFile.getWjm();
                this.log.info("minio\u4e0a\u4f20\u5730\u5740\uff1a{}", (Object)fileUrl);
                if (!Minio.isBlank(fileUrl)) {
                    sysSjglFile.setSclj(fileUrl);
                    sysSjglFile.setParent(bucketName);
                    return true;
                }
                return false;
            });
            return bl;
        }
        finally {
            FileUtil.closeStream(is);
        }
    }

    public static Result cszt(SysSjglSjzt sjzt) {
        try {
            MinioClient minioClient = Minio.createClient(sjzt);
            minioClient.listBuckets();
            return Minio.success("\u6d4b\u8bd5\u6210\u529f");
        }
        catch (Throwable t) {
            slog.debug("{}\u6d4b\u8bd5\u5931\u8d25", (Object)sjzt, (Object)t);
            return Minio.failed("\u8f7d\u4f53\u6d4b\u8bd5\u4e0d\u901a\u8fc7\uff1a" + t.getMessage());
        }
    }

    public static boolean validateClient(SysSjglSjzt sjzt, Object client) {
        try {
            MinioClient minioClient = (MinioClient)client;
            minioClient.listBuckets();
            return true;
        }
        catch (Exception e) {
            slog.debug("minioClient\u9a8c\u8bc1\u65e0\u6548\uff1a{}", (Object)sjzt.getMc(), (Object)e);
            return false;
        }
    }

    @Override
    public String getRootPath() {
        return this.sjzt.getKzxxObj().getString("$.config.server_url");
    }

    @Override
    public String getAbsolutePath(IFile file) {
        DbFile dbfile = (DbFile)file;
        SysSjglFile sysSjglFile = dbfile.getFile();
        return sysSjglFile.getSclj();
    }

    @Override
    public long getSize(IFile iFile) throws Exception {
        return iFile.length();
    }

    @Override
    public void close() throws IOException {
        if (!this.genericObjectPool.isClosed()) {
            this.genericObjectPool.close();
        }
        cache.remove((Object)this.name);
        if (this == minio) {
            minio = null;
        }
    }

    @Override
    public void sjztjt(SysSjglZnjh znjhConfig, InterfaceLog znjhJob) {
        throw new BusinessException("Minio\u4e0d\u652f\u6301\u76d1\u542c");
    }

    @Override
    public String getUrl(IFile ifile) {
        if (ifile instanceof DbFile) {
            return "/" + this.name + "/" + ((DbFile)ifile).getFile().getSclj();
        }
        return super.getUrl(ifile);
    }

    @Override
    public boolean zcUrl(IFile iFile) {
        return iFile instanceof DbFile;
    }
}

