/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt;

import cn.benma666.domain.SysSjglFile;
import cn.benma666.myutils.DateUtil;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.BasicFile;
import cn.benma666.sjzt.BasicSjzt;
import java.io.File;

public class DbFile
extends BasicFile {
    private SysSjglFile file;
    private String name;

    public DbFile(SysSjglFile file) {
        super(file.getParent(), BasicSjzt.useSjzt(file.getSjzt()));
        this.file = file;
        if (StringUtil.isBlank((String)file.getSclj())) {
            if (file.isWjmjhz()) {
                this.setName(file.getId() + file.getWjm());
            } else {
                this.name = file.getWjm();
            }
        } else {
            this.name = new File(file.getSclj()).getName();
        }
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public long length() {
        return this.file.getWjdx();
    }

    @Override
    public long lastModified() {
        return DateUtil.parseDate(this.file.getGxsj()).getTime();
    }

    public void setFile(SysSjglFile file) {
        this.file = file;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public SysSjglFile getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

