/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import cn.benma666.myutils.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.EncryptionMethod;

public class ZipUtil {
    public static File[] unzipDir(String zipDir, String dest, String passwd) throws ZipException {
        ArrayList<File> result = new ArrayList<File>();
        File zips = new File(zipDir);
        for (File zip : zips.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("zip");
            }
        })) {
            result.addAll(Arrays.asList(ZipUtil.unzip(zip.getAbsolutePath(), dest, passwd)));
        }
        return result.toArray(new File[0]);
    }

    public static File[] unzip(String zip, String dest, String passwd) throws ZipException {
        File zipFile = new File(zip);
        return ZipUtil.unzip(zipFile, dest, passwd);
    }

    public static File[] unzip(String zip, String passwd) throws ZipException {
        File zipFile = new File(zip);
        File parentDir = zipFile.getParentFile();
        return ZipUtil.unzip(zipFile, parentDir.getAbsolutePath(), passwd);
    }

    public static File[] unzip(File zipFile, String dest, String passwd) throws ZipException {
        ZipFile zFile = new ZipFile(zipFile);
        if (!zFile.isValidZipFile()) {
            throw new ZipException("\u538b\u7f29\u6587\u4ef6\u4e0d\u5408\u6cd5,\u53ef\u80fd\u88ab\u635f\u574f.");
        }
        File destDir = new File(dest);
        if (destDir.isDirectory() && !destDir.exists()) {
            destDir.mkdir();
        }
        if (zFile.isEncrypted()) {
            zFile.setPassword(passwd.toCharArray());
        }
        zFile.extractAll(dest);
        List headerList = zFile.getFileHeaders();
        ArrayList<File> extractedFileList = new ArrayList<File>();
        for (FileHeader fileHeader : headerList) {
            if (fileHeader.isDirectory()) continue;
            extractedFileList.add(new File(destDir, fileHeader.getFileName()));
        }
        File[] extractedFiles = new File[extractedFileList.size()];
        extractedFileList.toArray(extractedFiles);
        return extractedFiles;
    }

    public static String zip(String src) {
        return ZipUtil.zip(src, null);
    }

    public static String zip(String src, String passwd) {
        return ZipUtil.zip(src, null, passwd);
    }

    public static String zip(String src, String dest, String passwd) {
        return ZipUtil.zip(src, dest, true, passwd);
    }

    public static String zip(String src, String dest, boolean isCreateDir, String passwd) {
        File srcFile = new File(src);
        dest = ZipUtil.buildDestinationZipFilePath(srcFile, dest);
        ZipParameters parameters = new ZipParameters();
        if (!StringUtil.isEmpty((String)passwd)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
        }
        try {
            ZipFile zipFile = new ZipFile(dest);
            zipFile.setPassword(passwd.toCharArray());
            if (srcFile.isDirectory()) {
                if (!isCreateDir) {
                    File[] subFiles = srcFile.listFiles();
                    ArrayList temp = new ArrayList();
                    Collections.addAll(temp, subFiles);
                    zipFile.addFiles(temp, parameters);
                    return dest;
                }
                zipFile.addFolder(srcFile, parameters);
            } else {
                zipFile.addFile(srcFile, parameters);
            }
            return dest;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String buildDestinationZipFilePath(File srcFile, String destParam) {
        if (StringUtil.isEmpty((String)destParam)) {
            if (srcFile.isDirectory()) {
                destParam = srcFile.getParent() + File.separator + srcFile.getName() + ".zip";
            } else {
                String fileName = srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                destParam = srcFile.getParent() + File.separator + fileName + ".zip";
            }
        } else {
            ZipUtil.createDestDirectoryIfNecessary(destParam);
            if (destParam.endsWith(File.separator)) {
                String fileName = "";
                fileName = srcFile.isDirectory() ? srcFile.getName() : srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                destParam = destParam + fileName + ".zip";
            }
        }
        return destParam;
    }

    private static void createDestDirectoryIfNecessary(String destParam) {
        File destDir = null;
        destDir = destParam.endsWith(File.separator) ? new File(destParam) : new File(destParam.substring(0, destParam.lastIndexOf(File.separator)));
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
    }

    public static void main(String[] args) throws ZipException {
        ZipUtil.unzip("e:\\temp\\Codeing.zip", "e:\\temp\\111", "11");
    }
}

