/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import cn.benma666.constants.Charset;
import cn.benma666.dict.Xzms;
import cn.benma666.domain.SysSjglFile;
import cn.benma666.iframe.BasicObject;
import cn.benma666.iframe.DictManager;
import cn.benma666.myutils.StringUtil;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebUtil
extends BasicObject {
    public static final String CONTENTTYPE_APPLICATION_STREAM = "application/octet-stream";
    public static final String CONTENTTYPE_APPLICATION_EXCEL = "application/vnd.ms-excel";
    public static final String CONTENTTYPE_APPLICATION_JSON = "application/json";
    public static final String CONTENTTYPE_TEXTHTML = "text/html";
    public static final String CONTENTTYPE_TEXTJSON = "text/json";
    public static final String CONTENTTYPE_TEXTXML = "text/xml";
    public static final String CONTENTTYPE_TEXT = "text/plain";

    public static void sendText(HttpServletResponse response, String s) {
        WebUtil.sendDirectToClient(response, s, CONTENTTYPE_TEXT, Charset.UTF_8.getCode());
    }

    public static void sendJson(HttpServletResponse response, String s) {
        WebUtil.sendDirectToClient(response, s, CONTENTTYPE_TEXTJSON, Charset.UTF_8.getCode());
    }

    public static void sendJson(HttpServletResponse response, Object o) {
        String data = o instanceof JSON ? o.toString() : JSON.toJSONString((Object)o, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        WebUtil.sendDirectToClient(response, data, CONTENTTYPE_TEXTJSON, Charset.UTF_8.getCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendDirectToClient(HttpServletResponse resp, String s, String contentType, String charset) {
        String charsetPrefix = ";charset=";
        String contentHead = contentType + charsetPrefix + charset;
        resp.setContentType(contentHead);
        PrintWriter writer = null;
        try {
            writer = resp.getWriter();
            writer.write(s);
            writer.flush();
        }
        catch (IOException e) {
            slog.debug("\u50cf\u524d\u7aef\u53d1\u9001\u6570\u636e\u5931\u8d25:" + e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    slog.debug("\u6d41\u5173\u95ed\u5931\u8d25:" + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBytes(HttpServletResponse resp, byte[] data, SysSjglFile fileObj) {
        ServletOutputStream so = null;
        try {
            WebUtil.setFileDownloadHead(resp, fileObj);
            so = resp.getOutputStream();
            resp.setContentLength(data.length);
            so.write(data);
        }
        catch (Exception e) {
            slog.debug("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:" + e.getMessage());
        }
        finally {
            try {
                so.flush();
                so.close();
            }
            catch (Exception e) {
                slog.debug("\u6d41\u5173\u95ed\u5931\u8d25:" + e.getMessage());
            }
        }
    }

    public static void setFileDownloadHead(HttpServletResponse resp, SysSjglFile fileObj) throws UnsupportedEncodingException {
        String type = CONTENTTYPE_APPLICATION_STREAM;
        if (StringUtil.isNotBlank((String)fileObj.getWjlx()) && fileObj.getXzms() == Xzms.AWJLXXZ.getCode()) {
            type = DictManager.zdMcByDm("SYS_COMMON_XZTLX", fileObj.getWjlx());
            if (fileObj.getWjlx().equals(type)) {
                type = CONTENTTYPE_APPLICATION_STREAM;
            }
        }
        if (CONTENTTYPE_APPLICATION_STREAM.equals(type)) {
            type = "application/octet-stream;charset=" + Charset.GBK.getCode();
        }
        resp.setHeader("Content-Disposition", "attachment;filename=" + new String(fileObj.getWjm().getBytes(Charset.GBK.getCode()), StandardCharsets.ISO_8859_1));
        resp.setHeader("filename", URLEncoder.encode(fileObj.getWjm(), StandardCharsets.UTF_8.name()));
        resp.setContentType(type);
    }

    public static void sendFile(HttpServletResponse resp, String data, SysSjglFile fileObj) {
        WebUtil.sendBytes(resp, data.getBytes(), fileObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendFile(HttpServletResponse resp, File file, SysSjglFile fileObj) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            WebUtil.sendBytes(resp, Utils.readByteArray((InputStream)new FileInputStream(file)), fileObj);
        }
        catch (Exception e) {
            slog.debug("\u50cf\u524d\u7aef\u53d1\u9001\u6570\u636e\u5931\u8d25:" + e.getMessage());
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception e) {
                    slog.debug("\u50cf\u524d\u7aef\u53d1\u9001\u6570\u636e\u5931\u8d25:" + e.getMessage());
                }
            }
        }
    }

    public static String getString(HttpServletRequest request, String name, String dval) {
        return WebUtil.getRequestValue(request, name);
    }

    public static boolean getBoolean(HttpServletRequest request, String name, boolean dval) {
        return TypeUtils.castToBoolean((Object)WebUtil.getRequestValue(request, name));
    }

    public static int getInt(HttpServletRequest request, String name, int dval) {
        return TypeUtils.castToInt((Object)WebUtil.getRequestValue(request, name));
    }

    public static long getLong(HttpServletRequest request, String name, long dval) {
        return TypeUtils.castToLong((Object)WebUtil.getRequestValue(request, name));
    }

    public static double getDouble(HttpServletRequest request, String name, double dval) {
        return TypeUtils.castToDouble((Object)WebUtil.getRequestValue(request, name));
    }

    public static float getFloat(HttpServletRequest request, String name, float dval) {
        return TypeUtils.castToFloat((Object)WebUtil.getRequestValue(request, name)).floatValue();
    }

    private static String getRequestValue(HttpServletRequest request, String name) {
        String value = null;
        try {
            value = request.getParameter(name);
        }
        catch (Exception e) {
            value = null;
        }
        return value;
    }

    public static String getBasePath(HttpServletRequest request) {
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        return basePath;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static Object[] removeNUll(Object ... args) {
        int j = args.length;
        for (int i = 0; i < j; ++i) {
            if (args[i] != null) continue;
            args[i] = "";
        }
        return args;
    }

    public static Double getTimeToDouble(Date t) {
        if (t == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return Double.parseDouble(format.format(t));
    }
}

