/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import cn.benma666.myutils.StringUtil;
import de.innosystec.unrar.Archive;
import de.innosystec.unrar.exception.RarException;
import de.innosystec.unrar.rarfile.FileHeader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class RarUtilPwd {
    private static boolean isRarNameToDir = false;
    public static final String SEPARATOR = File.separator;

    public static void unRarDir(String rarDir, String dest, String pwd) throws Exception {
        File zips = new File(rarDir);
        for (File zip : zips.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rar");
            }
        })) {
            RarUtilPwd.unrar(zip.getAbsolutePath(), dest, pwd);
        }
    }

    public static void unrar(String srcRar, String password) throws IOException {
        RarUtilPwd.unrar(srcRar, null, password);
    }

    public static void unrar(String srcRar, String destPath, String password) throws IOException {
        File srcFile = new File(srcRar);
        if (!srcFile.exists()) {
            return;
        }
        if (null == destPath || destPath.length() == 0) {
            RarUtilPwd.unrar(srcFile, srcFile.getParent(), password);
            return;
        }
        RarUtilPwd.unrar(srcFile, destPath, password);
    }

    public static void unrar(File srcRarFile, String password) throws IOException {
        if (null == srcRarFile || !srcRarFile.exists()) {
            throw new IOException("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728.");
        }
        RarUtilPwd.unrar(srcRarFile, srcRarFile.getParent(), password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unrar(File srcRarFile, String destPath, String password) throws IOException {
        if (null == srcRarFile || !srcRarFile.exists()) {
            throw new IOException("\u6307\u5b9a\u538b\u7f29\u6587\u4ef6\u4e0d\u5b58\u5728.");
        }
        if (!destPath.endsWith(SEPARATOR)) {
            destPath = destPath + SEPARATOR;
        }
        Archive archive = null;
        FileOutputStream unOut = null;
        try {
            archive = new Archive(srcRarFile, password, false);
            FileHeader fileHeader = archive.nextFileHeader();
            while (null != fileHeader) {
                if (!fileHeader.isDirectory()) {
                    String destFileName = "";
                    String destDirName = "";
                    String fileName = fileHeader.getFileNameW();
                    if (StringUtil.isBlank((String)fileName)) {
                        fileName = fileHeader.getFileNameString();
                    }
                    if (SEPARATOR.equals("/")) {
                        destFileName = (destPath + fileName).replaceAll("\\\\", "/");
                        destDirName = destFileName.substring(0, destFileName.lastIndexOf("/"));
                    } else {
                        destFileName = (destPath + fileName).replaceAll("/", "\\\\");
                        destDirName = destFileName.substring(0, destFileName.lastIndexOf("\\"));
                    }
                    File dir = new File(destDirName);
                    if (!dir.exists() || !dir.isDirectory()) {
                        dir.mkdirs();
                    }
                    unOut = new FileOutputStream(new File(destFileName));
                    archive.extractFile(fileHeader, (OutputStream)unOut);
                    unOut.flush();
                    ((OutputStream)unOut).close();
                }
                fileHeader = archive.nextFileHeader();
            }
            archive.close();
        }
        catch (RarException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(unOut);
        }
    }

    public static boolean isRarNameToDir() {
        return isRarNameToDir;
    }

    public static void setRarNameToDir(boolean isRarNameToDir) {
        RarUtilPwd.isRarNameToDir = isRarNameToDir;
    }
}

