/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import cn.benma666.myutils.StringUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import net.lingala.zip4j.exception.ZipException;

public class RarUtil {
    private static boolean isRarNameToDir = false;

    public static void unRarDir(String rarDir, String dest) throws ZipException {
        File zips = new File(rarDir);
        for (File zip : zips.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rar");
            }
        })) {
            RarUtil.unRarFile(zip.getAbsolutePath(), dest);
        }
    }

    public static void unRarFile(String srcRarPath, String dstDirectoryPath) {
        block13: {
            if (!srcRarPath.toLowerCase().endsWith(".rar")) {
                System.out.println("\u975erar\u6587\u4ef6\uff01");
                return;
            }
            File dstDiretory = new File(dstDirectoryPath);
            if (!dstDiretory.exists()) {
                dstDiretory.mkdirs();
            }
            Archive a = null;
            try {
                File srcFile = new File(srcRarPath);
                String rarName = srcFile.getName().substring(0, srcFile.getName().indexOf("."));
                a = new Archive(srcFile);
                if (a == null) break block13;
                a.getMainHeader().print();
                FileHeader fh = a.nextFileHeader();
                while (fh != null) {
                    System.out.println(JSONObject.toJSON((Object)fh));
                    if (fh.isDirectory()) {
                        File fol = new File(dstDirectoryPath + File.separator + fh.getFileNameString());
                        fol.mkdirs();
                    } else {
                        String fileName = fh.getFileNameW();
                        if (StringUtil.isBlank((String)fileName)) {
                            fileName = fh.getFileNameString();
                        }
                        if (isRarNameToDir) {
                            fileName = rarName + File.separator + fileName;
                        }
                        File out = new File(dstDirectoryPath + File.separator + fileName);
                        try {
                            if (!out.exists()) {
                                if (!out.getParentFile().exists()) {
                                    out.getParentFile().mkdirs();
                                }
                                out.createNewFile();
                            }
                            FileOutputStream os = new FileOutputStream(out);
                            a.extractFile(fh, (OutputStream)os);
                            os.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    fh = a.nextFileHeader();
                }
                a.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isRarNameToDir() {
        return isRarNameToDir;
    }

    public static void setRarNameToDir(boolean isRarNameToDir) {
        RarUtil.isRarNameToDir = isRarNameToDir;
    }
}

