/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import java.util.List;

public class JWDUtil {
    private static final double pi = Math.PI;
    private static final double x_pi = 52.35987755982988;
    private static final double EARTH_RADIUS = 6378245.0;
    private static final double ee = 0.006693421622965943;

    private static double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * Math.PI) + 40.0 * Math.sin(y / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * Math.PI) + 320.0 * Math.sin(y * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    private static double transformLon(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * Math.PI) + 40.0 * Math.sin(x / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * Math.PI) + 300.0 * Math.sin(x / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    private static double[] transform(double lat, double lon) {
        if (JWDUtil.outOfChina(lat, lon)) {
            return new double[]{lat, lon};
        }
        double dLat = JWDUtil.transformLat(lon - 105.0, lat - 35.0);
        double dLon = JWDUtil.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (6335552.717000426 / (magic * sqrtMagic) * Math.PI);
        dLon = dLon * 180.0 / (6378245.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new double[]{mgLat, mgLon};
    }

    private static boolean outOfChina(double lat, double lon) {
        if (lon < 72.004 || lon > 137.8347) {
            return true;
        }
        return lat < 0.8293 || lat > 55.8271;
    }

    public static double[] Gps84_To_Gcj02(double lat, double lon) {
        if (JWDUtil.outOfChina(lat, lon)) {
            return new double[]{lat, lon};
        }
        double dLat = JWDUtil.transformLat(lon - 105.0, lat - 35.0);
        double dLon = JWDUtil.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (6335552.717000426 / (magic * sqrtMagic) * Math.PI);
        dLon = dLon * 180.0 / (6378245.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        double[] Gcj02 = new double[]{mgLat, mgLon};
        return Gcj02;
    }

    public static double[] Gcj02_To_Gps84(double lat, double lon) {
        double[] gps = JWDUtil.transform(lat, lon);
        double latitude = lat * 2.0 - gps[0];
        double lontitude = lon * 2.0 - gps[1];
        double[] Gps84 = new double[]{latitude, lontitude};
        return Gps84;
    }

    public static double[] Gcj02_To_Bd09(double lat, double lon) {
        double x = lon;
        double y = lat;
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * 52.35987755982988);
        double tempLat = z * Math.sin(theta) + 0.006;
        double tempLon = z * Math.cos(theta) + 0.0065;
        double[] Bd09 = new double[]{tempLat, tempLon};
        return Bd09;
    }

    public static double[] Bd09_To_Gcj02(double lat, double lon) {
        double x = lon - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        double tempLon = z * Math.cos(theta);
        double tempLat = z * Math.sin(theta);
        double[] Gcj02 = new double[]{tempLat, tempLon};
        return Gcj02;
    }

    public static double[] Gps84_To_Bd09(double lat, double lon) {
        double[] Gcj02 = JWDUtil.Gps84_To_Gcj02(lat, lon);
        double[] Bd09 = JWDUtil.Gcj02_To_Bd09(Gcj02[0], Gcj02[1]);
        return Bd09;
    }

    public static double[] Bd09_To_Gps84(double lat, double lon) {
        double[] Gcj02 = JWDUtil.Bd09_To_Gcj02(lat, lon);
        double[] Gps84 = JWDUtil.Gcj02_To_Gps84(Gcj02[0], Gcj02[1]);
        Gps84[0] = JWDUtil.retain6(Gps84[0]);
        Gps84[1] = JWDUtil.retain6(Gps84[1]);
        return Gps84;
    }

    private static double retain6(double num) {
        String result = String.format("%.6f", num);
        return Double.valueOf(result);
    }

    public static LatLng calculateCenter(List<LatLng> points) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (LatLng point : points) {
            double latitude = Math.toRadians(point.latitude);
            double longitude = Math.toRadians(point.longitude);
            x += Math.cos(latitude) * Math.cos(longitude);
            y += Math.cos(latitude) * Math.sin(longitude);
            z += Math.sin(latitude);
        }
        int totalPoints = points.size();
        double centralLongitude = Math.atan2(y /= (double)totalPoints, x /= (double)totalPoints);
        double centralSquareRoot = Math.sqrt(x * x + y * y);
        double centralLatitude = Math.atan2(z /= (double)totalPoints, centralSquareRoot);
        return new LatLng(Math.toDegrees(centralLatitude), Math.toDegrees(centralLongitude));
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double lng1, double lat1, double lng2, double lat2) {
        double radLat1 = JWDUtil.rad(lat1);
        double radLat2 = JWDUtil.rad(lat2);
        double a = radLat1 - radLat2;
        double b = JWDUtil.rad(lng1) - JWDUtil.rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6378245.0;
        s = Math.round(s * 10000.0) / 10000L;
        return s;
    }

    public static void main(String[] args) {
        double lat1 = 40.7128;
        double lon1 = -74.006;
        double lat2 = 51.5074;
        double lon2 = -0.1278;
        double distanceInMeters = JWDUtil.getDistance(lat1, lon1, lat2, lon2);
        System.out.println("\u4e24\u4e2a\u70b9\u4e4b\u95f4\u7684\u8ddd\u79bb\u4e3a\uff1a" + distanceInMeters + " \u7c73");
    }

    public static class LatLng {
        public double latitude;
        public double longitude;

        public LatLng(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }
    }
}

