/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import cn.benma666.constants.Charset;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.BasicObject;
import cn.benma666.iframe.Conf;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.HttpByHUC;
import cn.benma666.myutils.HttpByHttpClient;
import cn.benma666.myutils.HttpByOk;
import cn.benma666.myutils.HttpInterface;
import cn.benma666.myutils.StringUtil;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.entity.ContentType;

public class HttpUtil
extends BasicObject {
    public static final String REQUEST_METHOD = "RequestMethod";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String DEFAULT_QQBM = "UTF-8";
    public static final int DEFAULT_CSSC = 120000;
    protected static HttpUtil hu;
    private String qqbm;
    private int cssc;
    private JSONObject rp;
    private JSONObject repHeards;
    private HttpInterface hi;
    private String url;
    private Object param;
    private String fileKey;
    private String qqfs;

    public HttpUtil(HttpInterface hi) {
        this.setHi(hi);
    }

    private static HttpUtil getInstance() {
        if (hu == null) {
            hu = HttpUtil.builder().build();
        }
        return hu;
    }

    public static JSONObject doJosnByFrom(String url, Object param) {
        JSONObject rp = new JSONObject();
        rp.put(CONTENT_TYPE, (Object)"application/x-www-form-urlencoded;charset=UTF-8");
        String result = HttpUtil.doStr(url, param, DEFAULT_QQBM, 120000, rp);
        if (StringUtil.isNotBlank((String)result)) {
            return JSON.parseObject((String)result);
        }
        return new JSONObject();
    }

    public JSONObject josnByFrom() {
        return this.josnByFrom(this.url, this.param);
    }

    public JSONObject josnByFrom(String url, Object param) {
        this.rp.put(CONTENT_TYPE, (Object)("application/x-www-form-urlencoded;charset=" + this.qqbm));
        String result = this.str(url, param, this.qqbm, this.cssc, this.rp);
        if (StringUtil.isNotBlank((String)result)) {
            return JSON.parseObject((String)result);
        }
        return new JSONObject();
    }

    public static JSONObject doJosnByJson(String url, Object param) {
        JSONObject rp = new JSONObject();
        rp.put(CONTENT_TYPE, (Object)"application/json");
        String result = HttpUtil.doStr(url, param, DEFAULT_QQBM, 120000, rp);
        if (StringUtil.isNotBlank((String)result)) {
            try {
                return JSON.parseObject((String)result);
            }
            catch (Exception e) {
                throw new MyException("\u8bf7\u6c42\u7ed3\u679c\u89e3\u6790\u5931\u8d25\uff1a" + result, e);
            }
        }
        return new JSONObject();
    }

    public JSONObject josnByJson() {
        return this.josnByJson(this.url, this.param);
    }

    public JSONObject josnByJson(String url, Object param) {
        this.rp.put(CONTENT_TYPE, (Object)"application/json");
        String result = this.str(url, param, this.qqbm, this.cssc, this.rp);
        if (StringUtil.isNotBlank((String)result)) {
            try {
                return JSON.parseObject((String)result);
            }
            catch (Exception e) {
                throw new MyException("\u8bf7\u6c42\u7ed3\u679c\u89e3\u6790\u5931\u8d25\uff1a" + result, e);
            }
        }
        return new JSONObject();
    }

    public static String doStrByGet(String url, Object param) {
        JSONObject rp = new JSONObject();
        rp.put(REQUEST_METHOD, (Object)"GET");
        return HttpUtil.doStr(url, param, DEFAULT_QQBM, 120000, rp);
    }

    public String strByGet() {
        return this.strByGet(this.url, this.param);
    }

    public String strByGet(String url, Object param) {
        this.rp.put(REQUEST_METHOD, (Object)"GET");
        return this.str(url, param, this.qqbm, this.cssc, this.rp);
    }

    public static String doStr(String url, Object param) {
        return HttpUtil.doStr(url, param, DEFAULT_QQBM, 120000, new JSONObject());
    }

    public String str() {
        return this.str(this.url, this.param);
    }

    public String str(String url, Object param) {
        return this.str(url, param, this.qqbm, this.cssc, this.rp);
    }

    public static String doStr(String url, Object param, String qqbm, int cssc, JSONObject rp) {
        return HttpUtil.doStr(url, param, qqbm, cssc, rp, new JSONObject());
    }

    public String str(String url, Object param, String qqbm, int cssc, JSONObject rp) {
        this.repHeards.clear();
        return this.str(url, param, qqbm, cssc, rp, this.repHeards);
    }

    public static String doStr(String url, Object param, String qqbm, int cssc, JSONObject rp, JSONObject repHeards) {
        return HttpUtil.getInstance().str(url, param, qqbm, cssc, rp, repHeards);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String str(String url, Object param, String qqbm, int cssc, JSONObject rp, JSONObject repHeards) {
        String string;
        InputStream in = null;
        try {
            in = HttpUtil.doHttp(this.getHi(), url, param, qqbm, cssc, rp, repHeards);
            byte[] bytes = Utils.readByteArray((InputStream)in);
            String r = "";
            if (!HttpUtil.isBlank(bytes)) {
                r = new String(bytes, qqbm);
            }
            this.log.trace("\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)r);
            string = r;
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new MyException("\u4e0d\u652f\u6301\u7684\u7f16\u7801\uff1a" + qqbm, e);
                catch (IOException e2) {
                    throw new MyException("\u8bfb\u53d6\u8f93\u5165\u6d41\u5931\u8d25", e2);
                }
            }
            catch (Throwable throwable) {
                FileUtil.closeStream(in);
                throw throwable;
            }
        }
        FileUtil.closeStream(in);
        return string;
    }

    public InputStream getInputStream() {
        return HttpUtil.doHttp(this.getHi(), this.url, null, this.getQqbm(), this.getCssc(), this.getRp(), this.getRepHeards());
    }

    public InputStream getInputStream(String url) {
        return HttpUtil.doHttp(this.getHi(), url, null, this.getQqbm(), this.getCssc(), this.getRp(), this.getRepHeards());
    }

    public InputStream getInputStream(String url, Object param, String qqbm, int cssc, JSONObject rp, JSONObject repHeards) {
        return HttpUtil.doHttp(this.getHi(), url, param, qqbm, cssc, rp, repHeards);
    }

    public static InputStream inputStream(String url) {
        return HttpUtil.inputStream(url, null, DEFAULT_QQBM, 120000, null, new JSONObject());
    }

    public static InputStream inputStream(String url, Object param, String qqbm, int cssc, JSONObject rp, JSONObject repHeards) {
        return HttpUtil.doHttp(HttpUtil.getInstance().getHi(), url, param, qqbm, cssc, rp, repHeards);
    }

    public static InputStream doHttp(HttpInterface hi, String url, Object param, String qqbm, int cssc, JSONObject rp, JSONObject repHeards) {
        if (rp == null) {
            rp = new JSONObject();
        }
        if (repHeards == null) {
            repHeards = new JSONObject();
        }
        if (!HttpUtil.isBlank(param) && param instanceof Map && (HttpUtil.isBlank(rp.getString(CONTENT_TYPE)) || rp.getString(CONTENT_TYPE).contains(ContentType.APPLICATION_FORM_URLENCODED.getMimeType()))) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry e : ((Map)param).entrySet()) {
                if (HttpUtil.isBlank(e.getValue())) continue;
                try {
                    sb.append(e.getKey()).append("=").append(URLEncoder.encode(e.getValue().toString(), Charset.UTF_8.getCode())).append("&");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new MyException("\u53c2\u6570\u7f16\u7801\u5f02\u5e38\uff1a" + e.getKey() + "=" + e.getValue(), e);
                }
            }
            param = sb.toString();
        }
        if (HttpUtil.isBlank(url)) {
            throw new MyException("\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        slog.trace("\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, param);
        return hi.inputStream(url, param, qqbm, cssc, rp, repHeards);
    }

    static SSLContext trustAllHttpsCertificates() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllManager()};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
            return sc;
        }
        catch (Exception e) {
            throw new MyException("\u521b\u5efa\u5ffd\u7565\u8bc1\u4e66\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    static HostnameVerifier getHostnameVerifier() {
        return (s, sslSession) -> true;
    }

    private static HttpInterface defaultHi() {
        String httpgj;
        switch (httpgj = HttpUtil.valByDef(Conf.getValByConfig("benma666.default-http-util"), "huc")) {
            case "huc": {
                return HttpByHUC.getInstance();
            }
            case "ok": {
                return HttpByOk.getInstance();
            }
            case "hc": {
                return HttpByHttpClient.getInstance();
            }
        }
        throw new MyException("\u4e0d\u652f\u6301\u7684http\u5de5\u5177\uff1a" + httpgj);
    }

    private static String $default$qqbm() {
        return DEFAULT_QQBM;
    }

    private static int $default$cssc() {
        return 120000;
    }

    private static JSONObject $default$rp() {
        return new JSONObject();
    }

    private static JSONObject $default$repHeards() {
        return new JSONObject();
    }

    private static HttpInterface $default$hi() {
        return HttpUtil.defaultHi();
    }

    private static String $default$fileKey() {
        return "file";
    }

    private static String $default$qqfs() {
        return "POST";
    }

    public static HttpUtilBuilder builder() {
        return new HttpUtilBuilder();
    }

    public void setQqbm(String qqbm) {
        this.qqbm = qqbm;
    }

    public void setCssc(int cssc) {
        this.cssc = cssc;
    }

    public void setRp(JSONObject rp) {
        this.rp = rp;
    }

    public void setRepHeards(JSONObject repHeards) {
        this.repHeards = repHeards;
    }

    public void setHi(HttpInterface hi) {
        this.hi = hi;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setParam(Object param) {
        this.param = param;
    }

    public void setFileKey(String fileKey) {
        this.fileKey = fileKey;
    }

    public void setQqfs(String qqfs) {
        this.qqfs = qqfs;
    }

    public String getQqbm() {
        return this.qqbm;
    }

    public int getCssc() {
        return this.cssc;
    }

    public JSONObject getRp() {
        return this.rp;
    }

    public JSONObject getRepHeards() {
        return this.repHeards;
    }

    public HttpInterface getHi() {
        return this.hi;
    }

    public String getUrl() {
        return this.url;
    }

    public Object getParam() {
        return this.param;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public String getQqfs() {
        return this.qqfs;
    }

    public HttpUtil(String qqbm, int cssc, JSONObject rp, JSONObject repHeards, HttpInterface hi, String url, Object param, String fileKey, String qqfs) {
        this.qqbm = qqbm;
        this.cssc = cssc;
        this.rp = rp;
        this.repHeards = repHeards;
        this.hi = hi;
        this.url = url;
        this.param = param;
        this.fileKey = fileKey;
        this.qqfs = qqfs;
    }

    public HttpUtil() {
        this.qqbm = HttpUtil.$default$qqbm();
        this.cssc = HttpUtil.$default$cssc();
        this.rp = HttpUtil.$default$rp();
        this.repHeards = HttpUtil.$default$repHeards();
        this.hi = HttpUtil.$default$hi();
        this.fileKey = HttpUtil.$default$fileKey();
        this.qqfs = HttpUtil.$default$qqfs();
    }

    public static class HttpUtilBuilder {
        private boolean qqbm$set;
        private String qqbm$value;
        private boolean cssc$set;
        private int cssc$value;
        private boolean rp$set;
        private JSONObject rp$value;
        private boolean repHeards$set;
        private JSONObject repHeards$value;
        private boolean hi$set;
        private HttpInterface hi$value;
        private String url;
        private Object param;
        private boolean fileKey$set;
        private String fileKey$value;
        private boolean qqfs$set;
        private String qqfs$value;

        public HttpUtilBuilder addRp(String key, Object val) {
            if (this.rp$value == null) {
                this.rp$value = new JSONObject();
                this.rp$set = true;
            }
            this.rp$value.put(key, val);
            return this;
        }

        HttpUtilBuilder() {
        }

        public HttpUtilBuilder qqbm(String qqbm) {
            this.qqbm$value = qqbm;
            this.qqbm$set = true;
            return this;
        }

        public HttpUtilBuilder cssc(int cssc) {
            this.cssc$value = cssc;
            this.cssc$set = true;
            return this;
        }

        public HttpUtilBuilder rp(JSONObject rp) {
            this.rp$value = rp;
            this.rp$set = true;
            return this;
        }

        public HttpUtilBuilder repHeards(JSONObject repHeards) {
            this.repHeards$value = repHeards;
            this.repHeards$set = true;
            return this;
        }

        public HttpUtilBuilder hi(HttpInterface hi) {
            this.hi$value = hi;
            this.hi$set = true;
            return this;
        }

        public HttpUtilBuilder url(String url) {
            this.url = url;
            return this;
        }

        public HttpUtilBuilder param(Object param) {
            this.param = param;
            return this;
        }

        public HttpUtilBuilder fileKey(String fileKey) {
            this.fileKey$value = fileKey;
            this.fileKey$set = true;
            return this;
        }

        public HttpUtilBuilder qqfs(String qqfs) {
            this.qqfs$value = qqfs;
            this.qqfs$set = true;
            return this;
        }

        public HttpUtil build() {
            String qqbm$value = this.qqbm$value;
            if (!this.qqbm$set) {
                qqbm$value = HttpUtil.$default$qqbm();
            }
            int cssc$value = this.cssc$value;
            if (!this.cssc$set) {
                cssc$value = HttpUtil.$default$cssc();
            }
            JSONObject rp$value = this.rp$value;
            if (!this.rp$set) {
                rp$value = HttpUtil.$default$rp();
            }
            JSONObject repHeards$value = this.repHeards$value;
            if (!this.repHeards$set) {
                repHeards$value = HttpUtil.$default$repHeards();
            }
            HttpInterface hi$value = this.hi$value;
            if (!this.hi$set) {
                hi$value = HttpUtil.$default$hi();
            }
            String fileKey$value = this.fileKey$value;
            if (!this.fileKey$set) {
                fileKey$value = HttpUtil.$default$fileKey();
            }
            String qqfs$value = this.qqfs$value;
            if (!this.qqfs$set) {
                qqfs$value = HttpUtil.$default$qqfs();
            }
            return new HttpUtil(qqbm$value, cssc$value, rp$value, repHeards$value, hi$value, this.url, this.param, fileKey$value, qqfs$value);
        }

        public String toString() {
            return "HttpUtil.HttpUtilBuilder(qqbm$value=" + this.qqbm$value + ", cssc$value=" + this.cssc$value + ", rp$value=" + this.rp$value + ", repHeards$value=" + this.repHeards$value + ", hi$value=" + this.hi$value + ", url=" + this.url + ", param=" + this.param + ", fileKey$value=" + this.fileKey$value + ", qqfs$value=" + this.qqfs$value + ")";
        }
    }

    static class TrustAllManager
    implements X509TrustManager {
        TrustAllManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

