/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.json;

import cn.benma666.constants.UtilConstInstance;
import cn.benma666.myutils.ClassUtil;
import cn.benma666.myutils.StringUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyJSONObject
extends JSONObject
implements UtilConstInstance {
    private static final Logger log = LoggerFactory.getLogger(MyJSONObject.class);

    public MyJSONObject() {
        this(true);
    }

    public MyJSONObject(Map<String, Object> map) {
        super((Map)(map == null ? new HashMap() : map));
        if (map != null) {
            for (Map.Entry e : map.entrySet()) {
                this.set((String)e.getKey(), e.getValue());
            }
        }
    }

    public MyJSONObject(boolean ordered) {
        super(ordered);
    }

    public MyJSONObject(int initialCapacity) {
        super(initialCapacity);
    }

    public MyJSONObject(int initialCapacity, boolean ordered) {
        super(initialCapacity, ordered);
    }

    public Object get(Object key) {
        if (StringUtil.isBlank(key)) {
            return this.getInnerMap().get(key);
        }
        Object val = ClassUtil.getVal(key.toString(), super.get(key), this);
        if (val == null && key.toString().startsWith("$.")) {
            this.resetMap();
            val = JSONPath.eval((Object)this.getInnerMap(), (String)key.toString());
        }
        return val;
    }

    public Object put(String key, Object value) {
        return this.set(key, value);
    }

    public boolean set(String key, Object value) {
        return ClassUtil.setVal(key, value, this, this.getInnerMap());
    }

    public Set<String> keySet() {
        this.resetMap();
        return super.keySet();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this.resetMap();
        return super.entrySet();
    }

    public Collection<Object> values() {
        this.resetMap();
        return super.values();
    }

    public int size() {
        this.resetMap();
        return super.size();
    }

    private void resetMap() {
        Map map = this.getInnerMap();
        for (Method m : this.getClass().getDeclaredMethods()) {
            String field = null;
            if (m.getName().startsWith("get") && m.getParameterCount() == 0) {
                field = StringUtil.lowerCaseFast(m.getName().substring(3));
            } else if (m.getName().startsWith("is")) {
                field = StringUtil.lowerCaseFast(m.getName().substring(2));
            }
            try {
                if (field == null || m.invoke((Object)this, new Object[0]) == null) continue;
                map.put(field, m.invoke((Object)this, new Object[0]));
            }
            catch (Exception e) {
                log.debug("\u83b7\u53d6\u5c5e\u6027\u5931\u8d25\uff1a{}", (Object)m.getName());
            }
        }
    }

    public static MyJSONObject parseObject(String text, Feature ... features) {
        JSONObject obj = JSONObject.parseObject((String)text, (Feature[])features);
        return new MyJSONObject(obj.getInnerMap());
    }

    public String toJSONString() {
        JSONObject t = this.clone();
        return t.toJSONString();
    }

    public String toString(SerializerFeature ... features) {
        JSONObject t = this.clone();
        return t.toString(features);
    }

    public String toString() {
        return this.toJSONString();
    }
}

