/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.iframe;

import cn.benma666.exception.MyException;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class CacheFactory {
    public static final String TYPE_MEMORY = "memory";
    public static final String TYPE_REDIS = "redis";
    private static Map<String, JSONObject> cacheMap = new HashMap<String, JSONObject>();

    public static JSONObject use(String key, String type) {
        JSONObject c = cacheMap.get(key);
        if (c == null) {
            if (TYPE_REDIS.equals(type)) {
                throw new MyException("\u6682\u65f6\u4e0d\u652f\u6301redis\u7f13\u5b58\u673a\u5236");
            }
            c = new JSONObject();
            cacheMap.put(key, c);
        }
        return c;
    }

    public static JSONObject use(String key) {
        return CacheFactory.use(key, "default");
    }

    public static void clear() {
        for (Map.Entry<String, JSONObject> e : cacheMap.entrySet()) {
            e.getValue().clear();
        }
    }

    public static int clear(String key) {
        JSONObject cache = cacheMap.get(key);
        if (cache != null) {
            int size = cache.size();
            cache.clear();
            return size;
        }
        return -1;
    }

    public static Map<String, JSONObject> getCacheMap() {
        return cacheMap;
    }

    public static void setCacheMap(Map<String, JSONObject> cacheMap) {
        CacheFactory.cacheMap = cacheMap;
    }
}

